/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;

abstract class ListWithFilesAndPercentages {
    @Nonnull
    protected final PrintWriter output;
    @Nonnull
    private final String baseIndent;
    @Nonnegative
    int totalItems;
    @Nonnegative
    int coveredItems;

    ListWithFilesAndPercentages(@Nonnull PrintWriter output, @Nonnull String baseIndent) {
        this.output = output;
        this.baseIndent = baseIndent;
    }

    final void writeMetricsForEachFile(@Nullable String packageName, @Nonnull List<String> fileNames) {
        if (fileNames.isEmpty()) {
            return;
        }
        Collections.sort(fileNames);
        this.totalItems = 0;
        this.coveredItems = 0;
        for (String fileName : fileNames) {
            this.writeMetricsForFile(packageName, fileName);
        }
    }

    final void writeRowStart() {
        this.printIndent();
        this.output.println("<tr>");
    }

    final void writeRowClose() {
        this.printIndent();
        this.output.println("</tr>");
    }

    final void printIndent() {
        this.output.write(this.baseIndent);
    }

    protected abstract void writeMetricsForFile(@Nullable String var1, @Nonnull String var2);

    final void printCoveragePercentage(@Nonnegative int covered, @Nonnegative int total, int percentage) {
        this.printIndent();
        this.output.write("  <td ");
        if (total > 0) {
            this.writeRowCellWithCoveragePercentage(covered, total, percentage);
        } else {
            this.output.write("class='nocode'>N/A");
        }
        this.output.println("</td>");
    }

    private void writeRowCellWithCoveragePercentage(@Nonnegative int covered, @Nonnegative int total, @Nonnegative int percentage) {
        this.writeClassAttributeForCoveragePercentageCell();
        this.output.write("style='background-color:#");
        this.output.write(CoveragePercentage.percentageColor(covered, total));
        this.output.write("' title='Items: ");
        this.output.print(covered);
        this.output.write(47);
        this.output.print(total);
        this.output.write("'>");
        this.writePercentageValue(covered, total, percentage);
        this.output.print("%");
    }

    protected abstract void writeClassAttributeForCoveragePercentageCell();

    private void writePercentageValue(@Nonnegative int covered, @Nonnegative int total, @Nonnegative int percentage) {
        if (percentage < 100) {
            this.output.print(percentage);
        } else if (covered == total) {
            this.output.print("100");
        } else {
            this.output.print(">99");
        }
    }
}

