/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Entity;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionProviders;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.field.FieldToInject;
import mockit.internal.injection.full.FullInjection;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.util.DefaultValues;

public class Injector {
    private static final Pattern TYPE_NAME = Pattern.compile("class |interface |java\\.lang\\.");
    @Nonnull
    protected final InjectionState injectionState;
    @Nullable
    protected final FullInjection fullInjection;

    protected Injector(@Nonnull InjectionState state, @Nullable FullInjection fullInjection) {
        this.injectionState = state;
        this.fullInjection = fullInjection;
    }

    @Nonnull
    public static List<Field> findAllTargetInstanceFieldsInTestedClassHierarchy(@Nonnull Class<?> actualTestedClass, @Nonnull TestedClass testedClass) {
        ArrayList<Field> targetFields = new ArrayList<Field>();
        Class<?> classWithFields = actualTestedClass;
        do {
            Injector.addEligibleFields(targetFields, classWithFields);
        } while (testedClass.isClassFromSameModuleOrSystemAsTestedClass(classWithFields = classWithFields.getSuperclass()) || InjectionPoint.isServlet(classWithFields));
        return targetFields;
    }

    private static void addEligibleFields(@Nonnull List<Field> targetFields, @Nonnull Class<?> classWithFields) {
        Field[] fields;
        for (Field field : fields = classWithFields.getDeclaredFields()) {
            if (!Injector.isEligibleForInjection(field)) continue;
            targetFields.add(field);
        }
    }

    private static boolean isEligibleForInjection(@Nonnull Field field) {
        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            return false;
        }
        if (InjectionPoint.kindOfInjectionPoint(field) != InjectionPoint.KindOfInjectionPoint.NotAnnotated) {
            return true;
        }
        if (InjectionPoint.PERSISTENCE_UNIT_CLASS != null && field.getType().isAnnotationPresent(Entity.class)) {
            return false;
        }
        return !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers);
    }

    public final void fillOutDependenciesRecursively(@Nonnull Object dependency, @Nonnull TestedClass testedClass) {
        Class<?> dependencyClass = dependency.getClass();
        List<Field> targetFields = Injector.findAllTargetInstanceFieldsInTestedClassHierarchy(dependencyClass, testedClass);
        if (!targetFields.isEmpty()) {
            List<InjectionProvider> currentlyConsumedInjectables = this.injectionState.injectionProviders.saveConsumedInjectionProviders();
            this.injectIntoEligibleFields(targetFields, dependency, testedClass);
            this.injectionState.injectionProviders.restoreConsumedInjectionProviders(currentlyConsumedInjectables);
        }
    }

    public final void injectIntoEligibleFields(@Nonnull List<Field> targetFields, @Nonnull Object testedObject, @Nonnull TestedClass testedClass) {
        for (Field field : targetFields) {
            Object injectableValue;
            if (!Injector.targetFieldWasNotAssignedByConstructor(testedObject, field) || (injectableValue = this.getValueForFieldIfAvailable(targetFields, testedClass, field)) == null || injectableValue == InjectionProvider.NULL) continue;
            injectableValue = InjectionPoint.wrapInProviderIfNeeded(field.getGenericType(), injectableValue);
            FieldReflection.setFieldValue(field, testedObject, injectableValue);
        }
    }

    private static boolean targetFieldWasNotAssignedByConstructor(@Nonnull Object testedObject, @Nonnull Field targetField) {
        if (InjectionPoint.kindOfInjectionPoint(targetField) != InjectionPoint.KindOfInjectionPoint.NotAnnotated) {
            return true;
        }
        Object fieldValue = FieldReflection.getFieldValue(targetField, testedObject);
        if (fieldValue == null) {
            return true;
        }
        Class<?> fieldType = targetField.getType();
        if (!fieldType.isPrimitive()) {
            return false;
        }
        Object defaultValue = DefaultValues.defaultValueForPrimitiveType(fieldType);
        return fieldValue.equals(defaultValue);
    }

    @Nullable
    private Object getValueForFieldIfAvailable(@Nonnull List<Field> targetFields, @Nonnull TestedClass testedClass, @Nonnull Field targetField) {
        Object newInstance;
        InjectionPoint injectionPoint;
        String qualifiedFieldName = InjectionPoint.getQualifiedName(targetField.getDeclaredAnnotations());
        InjectionProvider injectable = this.findAvailableInjectableIfAny(targetFields, qualifiedFieldName, testedClass, targetField);
        if (injectable != null) {
            return this.injectionState.getValueToInject(injectable);
        }
        FieldToInject fieldToInject = new FieldToInject(targetField);
        Type typeToInject = fieldToInject.getDeclaredType();
        TestedClass nextTestedClass = typeToInject instanceof TypeVariable ? testedClass : new TestedClass(typeToInject, ((InjectionProvider)fieldToInject).getClassOfDeclaredType(), testedClass);
        Object testedValue = this.injectionState.getTestedValue(nextTestedClass, injectionPoint = new InjectionPoint(typeToInject, fieldToInject.getName(), qualifiedFieldName));
        if (testedValue != null) {
            return testedValue;
        }
        if (this.fullInjection != null && (newInstance = this.fullInjection.createOrReuseInstance(nextTestedClass, this, fieldToInject, qualifiedFieldName)) != null) {
            return newInstance;
        }
        InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint = InjectionPoint.kindOfInjectionPoint(targetField);
        this.throwExceptionIfUnableToInjectRequiredTargetField(kindOfInjectionPoint, targetField);
        return null;
    }

    @Nullable
    private InjectionProvider findAvailableInjectableIfAny(@Nonnull List<Field> targetFields, @Nullable String qualifiedTargetFieldName, @Nonnull TestedClass testedClass, @Nonnull Field targetField) {
        String injectableName;
        InjectionProvider matchingInjectable;
        InjectionProviders injectionProviders = this.injectionState.injectionProviders;
        injectionProviders.setTypeOfInjectionPoint(targetField.getGenericType());
        if (qualifiedTargetFieldName != null && !qualifiedTargetFieldName.isEmpty() && (matchingInjectable = injectionProviders.findInjectableByTypeAndName(injectableName = InjectionPoint.convertToLegalJavaIdentifierIfNeeded(qualifiedTargetFieldName), testedClass)) != null) {
            return matchingInjectable;
        }
        String targetFieldName = targetField.getName();
        return Injector.withMultipleTargetFieldsOfSameType(targetFields, testedClass, targetField, injectionProviders) ? injectionProviders.findInjectableByTypeAndName(targetFieldName, testedClass) : injectionProviders.getProviderByTypeAndOptionallyName(targetFieldName, testedClass);
    }

    private static boolean withMultipleTargetFieldsOfSameType(@Nonnull List<Field> targetFields, @Nonnull TestedClass testedClass, @Nonnull Field targetField, @Nonnull InjectionProviders injectionProviders) {
        for (Field anotherTargetField : targetFields) {
            if (anotherTargetField == targetField || !injectionProviders.isAssignableToInjectionPoint(anotherTargetField.getGenericType(), testedClass)) continue;
            return true;
        }
        return false;
    }

    private void throwExceptionIfUnableToInjectRequiredTargetField(@Nonnull InjectionPoint.KindOfInjectionPoint kindOfInjectionPoint, @Nonnull Field targetField) {
        if (kindOfInjectionPoint == InjectionPoint.KindOfInjectionPoint.Required) {
            Type fieldType = targetField.getGenericType();
            String fieldTypeName = fieldType.toString();
            fieldTypeName = TYPE_NAME.matcher(fieldTypeName).replaceAll("");
            String kindOfInjectable = "@Injectable";
            if (this.fullInjection != null) {
                kindOfInjectable = targetField.getType().isInterface() ? "@Tested instance of an implementation class" : "@Tested object";
            }
            throw new IllegalStateException("Missing " + kindOfInjectable + " for field \"" + fieldTypeName + ' ' + targetField.getName() + "\" in " + targetField.getDeclaringClass().getSimpleName());
        }
    }
}

