/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.InputStream;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.parser.core.xml.XsdStreamResolver;

public class ClassLoaderXsdStreamResolver
extends XsdStreamResolver {
    private static final Logger LOGGER = LogService.getLog(ClassLoaderXsdStreamResolver.class);

    @Override
    public InputStream getResourceAsStream(String xsdFile) {
        LOGGER.debug(LogType.LOG, "Trying to load resource from class classloader");
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(xsdFile);
        if (resourceAsStream == null) {
            LOGGER.debug(LogType.LOG, "Failed to load resource from class classloader");
            return this.getSuccessorValue(xsdFile);
        }
        return resourceAsStream;
    }
}

