/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.ant;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PropertySet;
import org.mybatis.generator.ant.AntProgressCallback;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class GeneratorAntTask
extends Task {
    private String configfile;
    private boolean overwrite;
    private PropertySet propertyset;
    private boolean verbose;
    private String contextIds;
    private String fullyQualifiedTableNames;

    public void execute() {
        File configurationFile = this.calculateConfigurationFile();
        Set<String> fullyqualifiedTables = this.calculateTables();
        Set<String> contexts = this.calculateContexts();
        ArrayList<String> warnings = new ArrayList<String>();
        try {
            Properties p = this.propertyset == null ? null : this.propertyset.getProperties();
            ConfigurationParser cp = new ConfigurationParser(p, warnings);
            Configuration config = cp.parseConfiguration(configurationFile);
            DefaultShellCallback callback = new DefaultShellCallback(this.overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, callback, warnings);
            myBatisGenerator.generate(new AntProgressCallback(this, this.verbose), contexts, fullyqualifiedTables);
        }
        catch (InvalidConfigurationException | XMLParserException e) {
            for (String error : e.getErrors()) {
                this.log(error, 0);
            }
            throw new BuildException(e.getMessage());
        }
        catch (IOException | SQLException e) {
            throw new BuildException(e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.log(e, 0);
            throw new BuildException(e.getMessage());
        }
        for (String error : warnings) {
            this.log(error, 1);
        }
    }

    private Set<String> calculateContexts() {
        HashSet<String> contexts = new HashSet<String>();
        if (StringUtility.stringHasValue(this.contextIds)) {
            StringTokenizer st = new StringTokenizer(this.contextIds, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                contexts.add(s);
            }
        }
        return contexts;
    }

    private Set<String> calculateTables() {
        HashSet<String> fullyqualifiedTables = new HashSet<String>();
        if (StringUtility.stringHasValue(this.fullyQualifiedTableNames)) {
            StringTokenizer st = new StringTokenizer(this.fullyQualifiedTableNames, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                fullyqualifiedTables.add(s);
            }
        }
        return fullyqualifiedTables;
    }

    private File calculateConfigurationFile() {
        if (!StringUtility.stringHasValue(this.configfile)) {
            throw new BuildException(Messages.getString("RuntimeError.0"));
        }
        File configurationFile = new File(this.configfile);
        if (!configurationFile.exists()) {
            throw new BuildException(Messages.getString("RuntimeError.1", this.configfile));
        }
        return configurationFile;
    }

    public String getConfigfile() {
        return this.configfile;
    }

    public void setConfigfile(String configfile) {
        this.configfile = configfile;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public PropertySet createPropertyset() {
        if (this.propertyset == null) {
            this.propertyset = new PropertySet();
        }
        return this.propertyset;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getContextIds() {
        return this.contextIds;
    }

    public void setContextIds(String contextIds) {
        this.contextIds = contextIds;
    }

    public String getFullyQualifiedTableNames() {
        return this.fullyQualifiedTableNames;
    }

    public void setFullyQualifiedTableNames(String fullyQualifiedTableNames) {
        this.fullyQualifiedTableNames = fullyQualifiedTableNames;
    }
}

