/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.DomainObjectRenamingRule;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class FullyQualifiedTable {
    private final String introspectedCatalog;
    private final String introspectedSchema;
    private final String introspectedTableName;
    private final String runtimeCatalog;
    private final String runtimeSchema;
    private final String runtimeTableName;
    private String domainObjectName;
    private String domainObjectSubPackage;
    private final String alias;
    private final boolean ignoreQualifiersAtRuntime;
    private final String beginningDelimiter;
    private final String endingDelimiter;
    private final DomainObjectRenamingRule domainObjectRenamingRule;

    public FullyQualifiedTable(String introspectedCatalog, String introspectedSchema, String introspectedTableName, String domainObjectName, String alias, boolean ignoreQualifiersAtRuntime, String runtimeCatalog, String runtimeSchema, String runtimeTableName, boolean delimitIdentifiers, DomainObjectRenamingRule domainObjectRenamingRule, Context context) {
        this.introspectedCatalog = introspectedCatalog;
        this.introspectedSchema = introspectedSchema;
        this.introspectedTableName = introspectedTableName;
        this.ignoreQualifiersAtRuntime = ignoreQualifiersAtRuntime;
        this.runtimeCatalog = runtimeCatalog;
        this.runtimeSchema = runtimeSchema;
        this.runtimeTableName = runtimeTableName;
        this.domainObjectRenamingRule = domainObjectRenamingRule;
        if (StringUtility.stringHasValue(domainObjectName)) {
            int index = domainObjectName.lastIndexOf(46);
            if (index == -1) {
                this.domainObjectName = domainObjectName;
            } else {
                this.domainObjectName = domainObjectName.substring(index + 1);
                this.domainObjectSubPackage = domainObjectName.substring(0, index);
            }
        }
        this.alias = alias == null ? null : alias.trim();
        this.beginningDelimiter = delimitIdentifiers ? context.getBeginningDelimiter() : "";
        this.endingDelimiter = delimitIdentifiers ? context.getEndingDelimiter() : "";
    }

    public String getIntrospectedCatalog() {
        return this.introspectedCatalog;
    }

    public String getIntrospectedSchema() {
        return this.introspectedSchema;
    }

    public String getIntrospectedTableName() {
        return this.introspectedTableName;
    }

    public String getFullyQualifiedTableNameAtRuntime() {
        StringBuilder localCatalog = new StringBuilder();
        if (!this.ignoreQualifiersAtRuntime) {
            if (StringUtility.stringHasValue(this.runtimeCatalog)) {
                localCatalog.append(this.runtimeCatalog);
            } else if (StringUtility.stringHasValue(this.introspectedCatalog)) {
                localCatalog.append(this.introspectedCatalog);
            }
        }
        if (localCatalog.length() > 0) {
            this.addDelimiters(localCatalog);
        }
        StringBuilder localSchema = new StringBuilder();
        if (!this.ignoreQualifiersAtRuntime) {
            if (StringUtility.stringHasValue(this.runtimeSchema)) {
                localSchema.append(this.runtimeSchema);
            } else if (StringUtility.stringHasValue(this.introspectedSchema)) {
                localSchema.append(this.introspectedSchema);
            }
        }
        if (localSchema.length() > 0) {
            this.addDelimiters(localSchema);
        }
        StringBuilder localTableName = new StringBuilder();
        if (StringUtility.stringHasValue(this.runtimeTableName)) {
            localTableName.append(this.runtimeTableName);
        } else {
            localTableName.append(this.introspectedTableName);
        }
        this.addDelimiters(localTableName);
        return StringUtility.composeFullyQualifiedTableName(localCatalog.toString(), localSchema.toString(), localTableName.toString(), '.');
    }

    public String getAliasedFullyQualifiedTableNameAtRuntime() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFullyQualifiedTableNameAtRuntime());
        if (StringUtility.stringHasValue(this.alias)) {
            sb.append(' ');
            sb.append(this.alias);
        }
        return sb.toString();
    }

    public String getDomainObjectName() {
        if (StringUtility.stringHasValue(this.domainObjectName)) {
            return this.domainObjectName;
        }
        String finalDomainObjectName = StringUtility.stringHasValue(this.runtimeTableName) ? JavaBeansUtil.getCamelCaseString(this.runtimeTableName, true) : JavaBeansUtil.getCamelCaseString(this.introspectedTableName, true);
        if (this.domainObjectRenamingRule != null) {
            Pattern pattern = Pattern.compile(this.domainObjectRenamingRule.getSearchString());
            String replaceString = this.domainObjectRenamingRule.getReplaceString();
            replaceString = replaceString == null ? "" : replaceString;
            Matcher matcher = pattern.matcher(finalDomainObjectName);
            finalDomainObjectName = JavaBeansUtil.getFirstCharacterUppercase(matcher.replaceAll(replaceString));
        }
        return finalDomainObjectName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FullyQualifiedTable)) {
            return false;
        }
        FullyQualifiedTable other = (FullyQualifiedTable)obj;
        return Objects.equals(this.introspectedTableName, other.introspectedTableName) && Objects.equals(this.introspectedCatalog, other.introspectedCatalog) && Objects.equals(this.introspectedSchema, other.introspectedSchema);
    }

    public int hashCode() {
        return Objects.hash(this.introspectedTableName, this.introspectedCatalog, this.introspectedCatalog);
    }

    public String toString() {
        return StringUtility.composeFullyQualifiedTableName(this.introspectedCatalog, this.introspectedSchema, this.introspectedTableName, '.');
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSubPackageForClientOrSqlMap(boolean isSubPackagesEnabled) {
        StringBuilder sb = new StringBuilder();
        if (!this.ignoreQualifiersAtRuntime && isSubPackagesEnabled) {
            if (StringUtility.stringHasValue(this.runtimeCatalog)) {
                sb.append('.');
                sb.append(this.runtimeCatalog.toLowerCase());
            } else if (StringUtility.stringHasValue(this.introspectedCatalog)) {
                sb.append('.');
                sb.append(this.introspectedCatalog.toLowerCase());
            }
            if (StringUtility.stringHasValue(this.runtimeSchema)) {
                sb.append('.');
                sb.append(this.runtimeSchema.toLowerCase());
            } else if (StringUtility.stringHasValue(this.introspectedSchema)) {
                sb.append('.');
                sb.append(this.introspectedSchema.toLowerCase());
            }
        }
        return sb.toString();
    }

    public String getSubPackageForModel(boolean isSubPackagesEnabled) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSubPackageForClientOrSqlMap(isSubPackagesEnabled));
        if (StringUtility.stringHasValue(this.domainObjectSubPackage)) {
            sb.append('.');
            sb.append(this.domainObjectSubPackage);
        }
        return sb.toString();
    }

    private void addDelimiters(StringBuilder sb) {
        if (StringUtility.stringHasValue(this.beginningDelimiter)) {
            sb.insert(0, this.beginningDelimiter);
        }
        if (StringUtility.stringHasValue(this.endingDelimiter)) {
            sb.append(this.endingDelimiter);
        }
    }

    public String getDomainObjectSubPackage() {
        return this.domainObjectSubPackage;
    }
}

