/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api;

import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.KotlinFormatter;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;

public class GeneratedKotlinFile
extends GeneratedFile {
    private final KotlinFile kotlinFile;
    private final String fileEncoding;
    private final KotlinFormatter kotlinFormatter;

    public GeneratedKotlinFile(KotlinFile kotlinFile, String targetProject, String fileEncoding, KotlinFormatter kotlinFormatter) {
        super(targetProject);
        this.kotlinFile = kotlinFile;
        this.fileEncoding = fileEncoding;
        this.kotlinFormatter = kotlinFormatter;
    }

    @Override
    public String getFormattedContent() {
        return this.kotlinFormatter.getFormattedContent(this.kotlinFile);
    }

    @Override
    public String getFileName() {
        return this.kotlinFile.getFileName();
    }

    @Override
    public String getTargetPackage() {
        return this.kotlinFile.getPackage().orElse("");
    }

    @Override
    public boolean isMergeable() {
        return false;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }
}

