/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java.render;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.mybatis.generator.api.dom.OutputUtilities;

public class BodyLineRenderer {
    public List<String> render(List<String> bodyLines) {
        ArrayList<String> lines = new ArrayList<String>();
        int indentLevel = 1;
        StringBuilder sb = new StringBuilder();
        ListIterator<String> listIter = bodyLines.listIterator();
        while (listIter.hasNext()) {
            sb.setLength(0);
            String line = listIter.next();
            if (line.startsWith("}")) {
                --indentLevel;
            }
            OutputUtilities.javaIndent(sb, indentLevel);
            sb.append(line);
            lines.add(sb.toString());
            if (this.isCodeBlockStartExceptSwitchStatement(line) || line.endsWith(":")) {
                ++indentLevel;
            }
            if (!line.startsWith("break")) continue;
            if (listIter.hasNext()) {
                String nextLine = listIter.next();
                if (nextLine.startsWith("}")) {
                    ++indentLevel;
                }
                listIter.previous();
            }
            --indentLevel;
        }
        return lines;
    }

    private boolean isCodeBlockStartExceptSwitchStatement(String line) {
        return line.endsWith("{") && !line.startsWith("switch");
    }
}

