/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InitializationBlock;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TypeParameter;
import org.mybatis.generator.api.dom.java.render.FieldRenderer;
import org.mybatis.generator.api.dom.java.render.InitializationBlockRenderer;
import org.mybatis.generator.api.dom.java.render.InnerClassRenderer;
import org.mybatis.generator.api.dom.java.render.InnerEnumRenderer;
import org.mybatis.generator.api.dom.java.render.InnerInterfaceRenderer;
import org.mybatis.generator.api.dom.java.render.MethodRenderer;
import org.mybatis.generator.api.dom.java.render.TypeParameterRenderer;
import org.mybatis.generator.internal.util.CustomCollectors;
import org.mybatis.generator.internal.util.StringUtility;

public class RenderingUtilities {
    public static final String JAVA_INDENT = "    ";
    private static final TypeParameterRenderer typeParameterRenderer = new TypeParameterRenderer();
    private static final FieldRenderer fieldRenderer = new FieldRenderer();
    private static final InitializationBlockRenderer initializationBlockRenderer = new InitializationBlockRenderer();
    private static final MethodRenderer methodRenderer = new MethodRenderer();
    private static final InnerClassRenderer innerClassRenderer = new InnerClassRenderer();
    private static final InnerInterfaceRenderer innerInterfaceRenderer = new InnerInterfaceRenderer();
    private static final InnerEnumRenderer innerEnumRenderer = new InnerEnumRenderer();

    private RenderingUtilities() {
    }

    public static String renderTypeParameters(List<TypeParameter> typeParameters, CompilationUnit compilationUnit) {
        return typeParameters.stream().map(tp -> typeParameterRenderer.render((TypeParameter)tp, compilationUnit)).collect(CustomCollectors.joining(", ", "<", "> "));
    }

    public static List<String> renderFields(List<Field> fields, CompilationUnit compilationUnit) {
        return fields.stream().flatMap(f -> RenderingUtilities.renderField(f, compilationUnit)).collect(Collectors.toList());
    }

    private static Stream<String> renderField(Field field, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(fieldRenderer.render(field, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderInitializationBlocks(List<InitializationBlock> initializationBlocks) {
        return initializationBlocks.stream().flatMap(RenderingUtilities::renderInitializationBlock).collect(Collectors.toList());
    }

    private static Stream<String> renderInitializationBlock(InitializationBlock initializationBlock) {
        return RenderingUtilities.addEmptyLine(initializationBlockRenderer.render(initializationBlock).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderClassOrEnumMethods(List<Method> methods, CompilationUnit compilationUnit) {
        return methods.stream().flatMap(m -> RenderingUtilities.renderMethod(m, false, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInterfaceMethods(List<Method> methods, CompilationUnit compilationUnit) {
        return methods.stream().flatMap(m -> RenderingUtilities.renderMethod(m, true, compilationUnit)).collect(Collectors.toList());
    }

    private static Stream<String> renderMethod(Method method, boolean inInterface, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(methodRenderer.render(method, inInterface, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    private static Stream<String> addEmptyLine(Stream<String> in) {
        return Stream.of(in, Stream.of("")).flatMap(Function.identity());
    }

    public static List<String> renderInnerClasses(List<InnerClass> innerClasses, CompilationUnit compilationUnit) {
        return innerClasses.stream().flatMap(ic -> RenderingUtilities.renderInnerClass(ic, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInnerClassNoIndent(InnerClass innerClass, CompilationUnit compilationUnit) {
        return innerClassRenderer.render(innerClass, compilationUnit);
    }

    private static Stream<String> renderInnerClass(InnerClass innerClass, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(innerClassRenderer.render(innerClass, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderInnerInterfaces(List<InnerInterface> innerInterfaces, CompilationUnit compilationUnit) {
        return innerInterfaces.stream().flatMap(ii -> RenderingUtilities.renderInnerInterface(ii, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInnerInterfaceNoIndent(InnerInterface innerInterface, CompilationUnit compilationUnit) {
        return innerInterfaceRenderer.render(innerInterface, compilationUnit);
    }

    private static Stream<String> renderInnerInterface(InnerInterface innerInterface, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(innerInterfaceRenderer.render(innerInterface, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderInnerEnums(List<InnerEnum> innerEnums, CompilationUnit compilationUnit) {
        return innerEnums.stream().flatMap(ie -> RenderingUtilities.renderInnerEnum(ie, compilationUnit)).collect(Collectors.toList());
    }

    public static List<String> renderInnerEnumNoIndent(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        return innerEnumRenderer.render(innerEnum, compilationUnit);
    }

    private static Stream<String> renderInnerEnum(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        return RenderingUtilities.addEmptyLine(innerEnumRenderer.render(innerEnum, compilationUnit).stream().map(RenderingUtilities::javaIndent));
    }

    public static List<String> renderPackage(CompilationUnit compilationUnit) {
        ArrayList<String> answer = new ArrayList<String>();
        String pack = compilationUnit.getType().getPackageName();
        if (StringUtility.stringHasValue(pack)) {
            answer.add("package " + pack + ";");
            answer.add("");
        }
        return answer;
    }

    public static List<String> renderStaticImports(CompilationUnit compilationUnit) {
        if (compilationUnit.getStaticImports().isEmpty()) {
            return Collections.emptyList();
        }
        return RenderingUtilities.addEmptyLine(compilationUnit.getStaticImports().stream().map(s -> "import static " + s + ";")).collect(Collectors.toList());
    }

    public static List<String> renderImports(CompilationUnit compilationUnit) {
        Set<String> imports = RenderingUtilities.renderImports(compilationUnit.getImportedTypes());
        if (imports.isEmpty()) {
            return Collections.emptyList();
        }
        return RenderingUtilities.addEmptyLine(imports.stream()).collect(Collectors.toList());
    }

    private static Set<String> renderImports(Set<FullyQualifiedJavaType> imports) {
        return imports.stream().map(FullyQualifiedJavaType::getImportList).flatMap(Collection::stream).map(RenderingUtilities::toFullImport).collect(Collectors.toCollection(TreeSet::new));
    }

    private static String toFullImport(String s) {
        return "import " + s + ";";
    }

    private static String javaIndent(String in) {
        if (in.isEmpty()) {
            return in;
        }
        return JAVA_INDENT + in;
    }

    public static List<String> removeLastEmptyLine(List<String> lines) {
        if (lines.get(lines.size() - 1).isEmpty()) {
            return lines.subList(0, lines.size() - 1);
        }
        return lines;
    }
}

