/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.HashMap;
import java.util.Map;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;

public class JavaToKotlinTypeConverter {
    private static final Map<String, String> typeMap = new HashMap<String, String>();

    private JavaToKotlinTypeConverter() {
    }

    public static FullyQualifiedKotlinType convert(FullyQualifiedJavaType javaType) {
        FullyQualifiedKotlinType kotlinType = JavaToKotlinTypeConverter.convertBaseType(javaType);
        for (FullyQualifiedJavaType argument : javaType.getTypeArguments()) {
            kotlinType.addTypeArgument(JavaToKotlinTypeConverter.convert(argument));
        }
        return kotlinType;
    }

    private static FullyQualifiedKotlinType convertBaseType(FullyQualifiedJavaType javaType) {
        String typeName = javaType.getFullyQualifiedNameWithoutTypeParameters();
        return new FullyQualifiedKotlinType(typeMap.getOrDefault(typeName, typeName));
    }

    static {
        typeMap.put("java.lang.String", "kotlin.String");
        typeMap.put("java.lang.String[]", "kotlin.Array<kotlin.String>");
        typeMap.put("byte", "kotlin.Byte");
        typeMap.put("char", "kotlin.Char");
        typeMap.put("short", "kotlin.Short");
        typeMap.put("int", "kotlin.Int");
        typeMap.put("long", "kotlin.Long");
        typeMap.put("float", "kotlin.Float");
        typeMap.put("double", "kotlin.Double");
        typeMap.put("boolean", "kotlin.Boolean");
        typeMap.put("byte[]", "kotlin.ByteArray");
        typeMap.put("char[]", "kotlin.CharArray");
        typeMap.put("short[]", "kotlin.ShortArray");
        typeMap.put("int[]", "kotlin.IntArray");
        typeMap.put("long[]", "kotlin.LongArray");
        typeMap.put("float[]", "kotlin.FloatArray");
        typeMap.put("double[]", "kotlin.DoubleArray");
        typeMap.put("boolean[]", "kotlin.BooleanArray");
        typeMap.put("java.lang.Byte", "kotlin.Byte");
        typeMap.put("java.lang.Character", "kotlin.Char");
        typeMap.put("java.lang.Short", "kotlin.Short");
        typeMap.put("java.lang.Integer", "kotlin.Int");
        typeMap.put("java.lang.Long", "kotlin.Long");
        typeMap.put("java.lang.Float", "kotlin.Float");
        typeMap.put("java.lang.Double", "kotlin.Double");
        typeMap.put("java.lang.Boolean", "kotlin.Boolean");
        typeMap.put("java.lang.Byte[]", "kotlin.Array<kotlin.Byte>");
        typeMap.put("java.lang.Character[]", "kotlin.Array<kotlin.Char>");
        typeMap.put("java.lang.Short[]", "kotlin.Array<kotlin.Short>");
        typeMap.put("java.lang.Integer[]", "kotlin.Array<kotlin.Int>");
        typeMap.put("java.lang.Long[]", "kotlin.Array<kotlin.Long>");
        typeMap.put("java.lang.Float[]", "kotlin.Array<kotlin.Float.");
        typeMap.put("java.lang.Double[]", "kotlin.Array<kotlin.Double>");
        typeMap.put("java.lang.Boolean[]", "kotlin.Array<kotlin.Boolean>");
    }
}

