/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.kotlin.KotlinModifier;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItemVisitor;

public abstract class KotlinNamedItem {
    private final String name;
    private final List<KotlinModifier> modifiers = new ArrayList<KotlinModifier>();
    private final List<String> annotations = new ArrayList<String>();

    protected KotlinNamedItem(AbstractBuilder<?> builder) {
        this.name = ((AbstractBuilder)builder).name;
        this.modifiers.addAll(((AbstractBuilder)builder).modifiers);
        this.annotations.addAll(((AbstractBuilder)builder).annotations);
    }

    public String getName() {
        return this.name;
    }

    public List<KotlinModifier> getModifiers() {
        return this.modifiers;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public abstract <R> R accept(KotlinNamedItemVisitor<R> var1);

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private final String name;
        private final List<KotlinModifier> modifiers = new ArrayList<KotlinModifier>();
        private final List<String> annotations = new ArrayList<String>();

        protected AbstractBuilder(String name) {
            this.name = name;
        }

        public T withModifier(KotlinModifier modifier) {
            this.modifiers.add(modifier);
            return this.getThis();
        }

        public T withAnnotation(String annotation) {
            this.annotations.add(annotation);
            return this.getThis();
        }

        protected abstract T getThis();
    }
}

