/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItem;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItemVisitor;

public class KotlinProperty
extends KotlinNamedItem {
    private final String dataType;
    private final String initializationString;
    private final Type type;

    private KotlinProperty(Builder builder) {
        super(builder);
        this.dataType = builder.dataType;
        this.initializationString = builder.initializationString;
        this.type = Objects.requireNonNull(builder.type);
    }

    public Optional<String> getInitializationString() {
        return Optional.ofNullable(this.initializationString);
    }

    public Optional<String> getDataType() {
        return Optional.ofNullable(this.dataType);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public <R> R accept(KotlinNamedItemVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static Builder newVal(String name) {
        return new Builder(Type.VAL, name);
    }

    public static Builder newVar(String name) {
        return new Builder(Type.VAR, name);
    }

    public static class Builder
    extends KotlinNamedItem.AbstractBuilder<Builder> {
        private String dataType;
        private String initializationString;
        private final Type type;

        private Builder(Type type, String name) {
            super(name);
            this.type = type;
        }

        public Builder withInitializationString(String initializationString) {
            this.initializationString = initializationString;
            return this;
        }

        public Builder withDataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public KotlinProperty build() {
            return new KotlinProperty(this);
        }
    }

    public static enum Type {
        VAL("val"),
        VAR("var");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

