/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin.render;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItem;
import org.mybatis.generator.api.dom.kotlin.render.KotlinNamedItemRenderer;

public class KotlinFileRenderer {
    public String render(KotlinFile kotlinFile) {
        ArrayList<String> lines = new ArrayList<String>();
        KotlinNamedItemRenderer renderer = new KotlinNamedItemRenderer();
        kotlinFile.getPackage().ifPresent(p -> lines.add("package " + p));
        lines.addAll(this.prependBlankLineIfNotEmpty(lines.size(), this.renderImports(kotlinFile)));
        for (KotlinNamedItem item : kotlinFile.getNamedItems()) {
            lines.addAll(this.prependBlankLineIfNotEmpty(lines.size(), renderer.render(item)));
        }
        lines.addAll(0, kotlinFile.getFileCommentLines());
        return lines.stream().collect(Collectors.joining(System.getProperty("line.separator")));
    }

    private List<String> prependBlankLineIfNotEmpty(int currentLength, List<String> in) {
        if (in.isEmpty() || currentLength == 0) {
            return in;
        }
        in.add(0, "");
        return in;
    }

    private List<String> renderImports(KotlinFile kotlinFile) {
        return kotlinFile.getImports().stream().map(s -> "import " + s).collect(Collectors.toList());
    }
}

