/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.javamapper.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.AbstractGenerator;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.StringUtility;

public abstract class AbstractJavaMapperMethodGenerator
extends AbstractGenerator {
    public abstract void addInterfaceElements(Interface var1);

    protected AbstractJavaMapperMethodGenerator() {
    }

    protected static String getResultAnnotation(Interface interfaze, IntrospectedColumn introspectedColumn, boolean idColumn, boolean constructorBased) {
        StringBuilder sb = new StringBuilder();
        if (constructorBased) {
            interfaze.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            sb.append("@Arg(column=\"");
            sb.append(MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn));
            sb.append("\", javaType=");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getShortName());
            sb.append(".class");
        } else {
            sb.append("@Result(column=\"");
            sb.append(MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn));
            sb.append("\", property=\"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append('\"');
        }
        if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(introspectedColumn.getTypeHandler());
            interfaze.addImportedType(fqjt);
            sb.append(", typeHandler=");
            sb.append(fqjt.getShortName());
            sb.append(".class");
        }
        sb.append(", jdbcType=JdbcType.");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (idColumn) {
            sb.append(", id=true");
        }
        sb.append(')');
        return sb.toString();
    }

    protected Optional<String> buildGeneratedKeyAnnotation() {
        return this.introspectedTable.getGeneratedKey().flatMap(this::buildGeneratedKeyAnnotation);
    }

    private Optional<String> buildGeneratedKeyAnnotation(GeneratedKey gk) {
        return this.introspectedTable.getColumn(gk.getColumn()).map(ic -> this.buildGeneratedKeyAnnotation(gk, (IntrospectedColumn)ic));
    }

    private String buildGeneratedKeyAnnotation(GeneratedKey gk, IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        if (gk.isJdbcStandard()) {
            sb.append("@Options(useGeneratedKeys=true,keyProperty=\"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append("\")");
        } else {
            sb.append("@SelectKey(statement=\"");
            sb.append(gk.getRuntimeSqlStatement());
            sb.append("\", keyProperty=\"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append("\", before=");
            sb.append(gk.isIdentity() ? "false" : "true");
            sb.append(", resultType=");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getShortName());
            sb.append(".class)");
        }
        return sb.toString();
    }

    protected Set<FullyQualifiedJavaType> buildGeneratedKeyImportsIfRequired() {
        return this.introspectedTable.getGeneratedKey().map(this::buildGeneratedKeyImportsIfRequired).orElseGet(Collections::emptySet);
    }

    private Set<FullyQualifiedJavaType> buildGeneratedKeyImportsIfRequired(GeneratedKey gk) {
        return this.introspectedTable.getColumn(gk.getColumn()).map(ic -> this.buildGeneratedKeyImports(gk, (IntrospectedColumn)ic)).orElseGet(Collections::emptySet);
    }

    private Set<FullyQualifiedJavaType> buildGeneratedKeyImports(GeneratedKey gk, IntrospectedColumn introspectedColumn) {
        HashSet<FullyQualifiedJavaType> answer = new HashSet<FullyQualifiedJavaType>();
        if (gk.isJdbcStandard()) {
            answer.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options"));
        } else {
            answer.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.SelectKey"));
            answer.add(introspectedColumn.getFullyQualifiedJavaType());
        }
        return answer;
    }

    protected void addAnnotatedSelectImports(Interface interfaze) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.type.JdbcType"));
        if (this.introspectedTable.isConstructorBased()) {
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Arg"));
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.ConstructorArgs"));
        } else {
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Result"));
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Results"));
        }
    }

    protected List<String> buildByPrimaryKeyWhereClause() {
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean and = false;
        Iterator<IntrospectedColumn> iter = this.introspectedTable.getPrimaryKeyColumns().iterator();
        while (iter.hasNext()) {
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            if (and) {
                sb.append("  \"and ");
            } else {
                sb.append("\"where ");
                and = true;
            }
            IntrospectedColumn introspectedColumn = iter.next();
            sb.append(StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn)));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getParameterClause(introspectedColumn));
            sb.append('\"');
            if (iter.hasNext()) {
                sb.append(',');
            }
            answer.add(sb.toString());
        }
        return answer;
    }

    protected List<String> buildUpdateByPrimaryKeyAnnotations(List<IntrospectedColumn> columnList) {
        ArrayList<String> answer = new ArrayList<String>();
        answer.add("@Update({");
        StringBuilder sb = new StringBuilder();
        OutputUtilities.javaIndent(sb, 1);
        sb.append("\"update ");
        sb.append(StringUtility.escapeStringForJava(this.introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        sb.append("\",");
        answer.add(sb.toString());
        sb.setLength(0);
        OutputUtilities.javaIndent(sb, 1);
        sb.append("\"set ");
        Iterator<IntrospectedColumn> iter = ListUtilities.removeGeneratedAlwaysColumns(columnList).iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = iter.next();
            sb.append(StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn)));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getParameterClause(introspectedColumn));
            if (iter.hasNext()) {
                sb.append(',');
            }
            sb.append("\",");
            answer.add(sb.toString());
            if (!iter.hasNext()) continue;
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append("  \"");
        }
        answer.addAll(this.buildByPrimaryKeyWhereClause());
        answer.add("})");
        return answer;
    }

    protected void addPrimaryKeyMethodParameters(boolean isSimple, Method method, Set<FullyQualifiedJavaType> importedTypes) {
        if (!isSimple && this.introspectedTable.getRules().generatePrimaryKeyClass()) {
            FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getPrimaryKeyType());
            importedTypes.add(type);
            method.addParameter(new Parameter(type, "key"));
        } else {
            boolean annotate;
            List<IntrospectedColumn> introspectedColumns = this.introspectedTable.getPrimaryKeyColumns();
            boolean bl = annotate = introspectedColumns.size() > 1;
            if (annotate) {
                importedTypes.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param"));
            }
            StringBuilder sb = new StringBuilder();
            for (IntrospectedColumn introspectedColumn : introspectedColumns) {
                FullyQualifiedJavaType type = introspectedColumn.getFullyQualifiedJavaType();
                importedTypes.add(type);
                Parameter parameter = new Parameter(type, introspectedColumn.getJavaProperty());
                if (annotate) {
                    sb.setLength(0);
                    sb.append("@Param(\"");
                    sb.append(introspectedColumn.getJavaProperty());
                    sb.append("\")");
                    parameter.addAnnotation(sb.toString());
                }
                method.addParameter(parameter);
            }
        }
    }

    protected void addAnnotatedResults(Interface interfaze, Method method, List<IntrospectedColumn> nonPrimaryKeyColumns) {
        IntrospectedColumn introspectedColumn;
        if (this.introspectedTable.isConstructorBased()) {
            method.addAnnotation("@ConstructorArgs({");
        } else {
            method.addAnnotation("@Results({");
        }
        StringBuilder sb = new StringBuilder();
        Iterator<IntrospectedColumn> iterPk = this.introspectedTable.getPrimaryKeyColumns().iterator();
        Iterator<IntrospectedColumn> iterNonPk = nonPrimaryKeyColumns.iterator();
        while (iterPk.hasNext()) {
            introspectedColumn = iterPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(AbstractJavaMapperMethodGenerator.getResultAnnotation(interfaze, introspectedColumn, true, this.introspectedTable.isConstructorBased()));
            if (iterPk.hasNext() || iterNonPk.hasNext()) {
                sb.append(',');
            }
            method.addAnnotation(sb.toString());
        }
        while (iterNonPk.hasNext()) {
            introspectedColumn = iterNonPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(AbstractJavaMapperMethodGenerator.getResultAnnotation(interfaze, introspectedColumn, false, this.introspectedTable.isConstructorBased()));
            if (iterNonPk.hasNext()) {
                sb.append(',');
            }
            method.addAnnotation(sb.toString());
        }
        method.addAnnotation("})");
    }

    protected Method buildBasicUpdateByExampleMethod(String statementId, FullyQualifiedJavaType parameterType, Set<FullyQualifiedJavaType> importedTypes) {
        Method method = new Method(statementId);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setAbstract(true);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(parameterType, "row", "@Param(\"row\")"));
        importedTypes.add(parameterType);
        FullyQualifiedJavaType exampleType = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        method.addParameter(new Parameter(exampleType, "example", "@Param(\"example\")"));
        importedTypes.add(exampleType);
        importedTypes.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param"));
        this.context.getCommentGenerator().addGeneralMethodComment(method, this.introspectedTable);
        return method;
    }

    protected Method buildBasicUpdateByPrimaryKeyMethod(String statementId, FullyQualifiedJavaType parameterType) {
        Method method = new Method(statementId);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setAbstract(true);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(parameterType, "row"));
        this.context.getCommentGenerator().addGeneralMethodComment(method, this.introspectedTable);
        return method;
    }

    protected List<String> buildInitialSelectAnnotationStrings() {
        ArrayList<String> answer = new ArrayList<String>();
        answer.add("@Select({");
        StringBuilder sb = new StringBuilder();
        OutputUtilities.javaIndent(sb, 1);
        sb.append("\"select\",");
        answer.add(sb.toString());
        sb.setLength(0);
        OutputUtilities.javaIndent(sb, 1);
        sb.append('\"');
        boolean hasColumns = false;
        Iterator<IntrospectedColumn> iter = this.introspectedTable.getAllColumns().iterator();
        while (iter.hasNext()) {
            sb.append(StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getSelectListPhrase(iter.next())));
            hasColumns = true;
            if (iter.hasNext()) {
                sb.append(", ");
            }
            if (sb.length() <= 80) continue;
            sb.append("\",");
            answer.add(sb.toString());
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append('\"');
            hasColumns = false;
        }
        if (hasColumns) {
            sb.append("\",");
            answer.add(sb.toString());
        }
        return answer;
    }
}

