/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.List;
import org.mybatis.generator.config.PropertyHolder;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class ColumnOverride
extends PropertyHolder {
    private final String columnName;
    private String javaProperty;
    private String jdbcType;
    private String javaType;
    private String typeHandler;
    private boolean isColumnNameDelimited;
    private boolean isGeneratedAlways;

    public ColumnOverride(String columnName) {
        this.columnName = columnName;
        this.isColumnNameDelimited = StringUtility.stringContainsSpace(columnName);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getJavaProperty() {
        return this.javaProperty;
    }

    public void setJavaProperty(String javaProperty) {
        this.javaProperty = javaProperty;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(String typeHandler) {
        this.typeHandler = typeHandler;
    }

    public boolean isColumnNameDelimited() {
        return this.isColumnNameDelimited;
    }

    public void setColumnNameDelimited(boolean isColumnNameDelimited) {
        this.isColumnNameDelimited = isColumnNameDelimited;
    }

    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.columnName)) {
            errors.add(Messages.getString("ValidationError.22", tableName));
        }
    }

    public boolean isGeneratedAlways() {
        return this.isGeneratedAlways;
    }

    public void setGeneratedAlways(boolean isGeneratedAlways) {
        this.isGeneratedAlways = isGeneratedAlways;
    }
}

