/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config.xml;

import java.util.List;
import org.mybatis.generator.internal.util.messages.Messages;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ParserErrorHandler
implements ErrorHandler {
    private final List<String> warnings;
    private final List<String> errors;

    public ParserErrorHandler(List<String> warnings, List<String> errors) {
        this.warnings = warnings;
        this.errors = errors;
    }

    @Override
    public void warning(SAXParseException exception) {
        this.warnings.add(Messages.getString("Warning.7", Integer.toString(exception.getLineNumber()), exception.getMessage()));
    }

    @Override
    public void error(SAXParseException exception) {
        this.errors.add(Messages.getString("RuntimeError.4", Integer.toString(exception.getLineNumber()), exception.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.errors.add(Messages.getString("RuntimeError.4", Integer.toString(exception.getLineNumber()), exception.getMessage()));
    }
}

