/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal.util;

import java.util.Locale;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.util.StringUtility;

public class JavaBeansUtil {
    private JavaBeansUtil() {
    }

    public static String getGetterMethodName(String property, FullyQualifiedJavaType fullyQualifiedJavaType) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        if (fullyQualifiedJavaType.equals(FullyQualifiedJavaType.getBooleanPrimitiveInstance())) {
            sb.insert(0, "is");
        } else {
            sb.insert(0, "get");
        }
        return sb.toString();
    }

    public static String getSetterMethodName(String property) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        sb.insert(0, "set");
        return sb.toString();
    }

    public static String getFirstCharacterUppercase(String inputString) {
        StringBuilder sb = new StringBuilder(inputString);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static String getValidPropertyName(String inputString) {
        String answer = inputString == null ? null : (inputString.length() < 2 ? inputString.toLowerCase(Locale.US) : (Character.isUpperCase(inputString.charAt(0)) && !Character.isUpperCase(inputString.charAt(1)) ? inputString.substring(0, 1).toLowerCase(Locale.US) + inputString.substring(1) : inputString));
        return answer;
    }

    public static Method getJavaBeansGetter(IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable) {
        Method method = JavaBeansUtil.getBasicJavaBeansGetter(introspectedColumn);
        JavaBeansUtil.addGeneratedGetterJavaDoc(method, introspectedColumn, context, introspectedTable);
        return method;
    }

    public static Method getJavaBeansGetterWithGeneratedAnnotation(IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable, CompilationUnit compilationUnit) {
        Method method = JavaBeansUtil.getBasicJavaBeansGetter(introspectedColumn);
        JavaBeansUtil.addGeneratedGetterAnnotation(method, introspectedColumn, context, introspectedTable, compilationUnit);
        return method;
    }

    private static Method getBasicJavaBeansGetter(IntrospectedColumn introspectedColumn) {
        FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
        String property = introspectedColumn.getJavaProperty();
        Method method = new Method(JavaBeansUtil.getGetterMethodName(property, fqjt));
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(fqjt);
        String s = "return " + property + ';';
        method.addBodyLine(s);
        return method;
    }

    private static void addGeneratedGetterJavaDoc(Method method, IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable) {
        context.getCommentGenerator().addGetterComment(method, introspectedTable, introspectedColumn);
    }

    private static void addGeneratedGetterAnnotation(Method method, IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable, CompilationUnit compilationUnit) {
        context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, introspectedColumn, compilationUnit.getImportedTypes());
    }

    public static Field getJavaBeansField(IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable) {
        Field field = JavaBeansUtil.getBasicJavaBeansField(introspectedColumn);
        JavaBeansUtil.addGeneratedJavaDoc(field, context, introspectedColumn, introspectedTable);
        return field;
    }

    public static Field getJavaBeansFieldWithGeneratedAnnotation(IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable, CompilationUnit compilationUnit) {
        Field field = JavaBeansUtil.getBasicJavaBeansField(introspectedColumn);
        JavaBeansUtil.addGeneratedAnnotation(field, context, introspectedColumn, introspectedTable, compilationUnit);
        return field;
    }

    private static Field getBasicJavaBeansField(IntrospectedColumn introspectedColumn) {
        FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
        String property = introspectedColumn.getJavaProperty();
        Field field = new Field(property, fqjt);
        field.setVisibility(JavaVisibility.PRIVATE);
        return field;
    }

    private static void addGeneratedJavaDoc(Field field, Context context, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable) {
        context.getCommentGenerator().addFieldComment(field, introspectedTable, introspectedColumn);
    }

    private static void addGeneratedAnnotation(Field field, Context context, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, CompilationUnit compilationUnit) {
        context.getCommentGenerator().addFieldAnnotation(field, introspectedTable, introspectedColumn, compilationUnit.getImportedTypes());
    }

    public static Method getJavaBeansSetter(IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable) {
        Method method = JavaBeansUtil.getBasicJavaBeansSetter(introspectedColumn);
        JavaBeansUtil.addGeneratedSetterJavaDoc(method, introspectedColumn, context, introspectedTable);
        return method;
    }

    public static Method getJavaBeansSetterWithGeneratedAnnotation(IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable, CompilationUnit compilationUnit) {
        Method method = JavaBeansUtil.getBasicJavaBeansSetter(introspectedColumn);
        JavaBeansUtil.addGeneratedSetterAnnotation(method, introspectedColumn, context, introspectedTable, compilationUnit);
        return method;
    }

    private static Method getBasicJavaBeansSetter(IntrospectedColumn introspectedColumn) {
        FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
        String property = introspectedColumn.getJavaProperty();
        Method method = new Method(JavaBeansUtil.getSetterMethodName(property));
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(fqjt, property));
        StringBuilder sb = new StringBuilder();
        if (introspectedColumn.isStringColumn() && JavaBeansUtil.isTrimStringsEnabled(introspectedColumn)) {
            sb.append("this.");
            sb.append(property);
            sb.append(" = ");
            sb.append(property);
            sb.append(" == null ? null : ");
            sb.append(property);
            sb.append(".trim();");
            method.addBodyLine(sb.toString());
        } else {
            sb.append("this.");
            sb.append(property);
            sb.append(" = ");
            sb.append(property);
            sb.append(';');
            method.addBodyLine(sb.toString());
        }
        return method;
    }

    private static void addGeneratedSetterJavaDoc(Method method, IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable) {
        context.getCommentGenerator().addSetterComment(method, introspectedTable, introspectedColumn);
    }

    private static void addGeneratedSetterAnnotation(Method method, IntrospectedColumn introspectedColumn, Context context, IntrospectedTable introspectedTable, CompilationUnit compilationUnit) {
        context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, introspectedColumn, compilationUnit.getImportedTypes());
    }

    private static boolean isTrimStringsEnabled(Context context) {
        Properties properties = context.getJavaModelGeneratorConfiguration().getProperties();
        return StringUtility.isTrue(properties.getProperty("trimStrings"));
    }

    private static boolean isTrimStringsEnabled(IntrospectedTable table) {
        TableConfiguration tableConfiguration = table.getTableConfiguration();
        String trimSpaces = tableConfiguration.getProperties().getProperty("trimStrings");
        if (trimSpaces != null) {
            return StringUtility.isTrue(trimSpaces);
        }
        return JavaBeansUtil.isTrimStringsEnabled(table.getContext());
    }

    private static boolean isTrimStringsEnabled(IntrospectedColumn column) {
        String trimSpaces = column.getProperties().getProperty("trimStrings");
        if (trimSpaces != null) {
            return StringUtility.isTrue(trimSpaces);
        }
        return JavaBeansUtil.isTrimStringsEnabled(column.getIntrospectedTable());
    }
}

