/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class StringUtility {
    private StringUtility() {
    }

    public static boolean stringHasValue(String s) {
        return s != null && s.length() > 0;
    }

    public static String composeFullyQualifiedTableName(String catalog, String schema, String tableName, char separator) {
        StringBuilder sb = new StringBuilder();
        if (StringUtility.stringHasValue(catalog)) {
            sb.append(catalog);
            sb.append(separator);
        }
        if (StringUtility.stringHasValue(schema)) {
            sb.append(schema);
            sb.append(separator);
        } else if (sb.length() > 0) {
            sb.append(separator);
        }
        sb.append(tableName);
        return sb.toString();
    }

    public static boolean stringContainsSpace(String s) {
        return s != null && s.indexOf(32) != -1;
    }

    public static String escapeStringForJava(String s) {
        StringTokenizer st = new StringTokenizer(s, "\"", true);
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("\"".equals(token)) {
                sb.append("\\\"");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String escapeStringForKotlin(String s) {
        StringTokenizer st = new StringTokenizer(s, "\"$", true);
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("\"".equals(token)) {
                sb.append("\\\"");
                continue;
            }
            if ("$".equals(token)) {
                sb.append("\\$");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static boolean isTrue(String s) {
        return "true".equalsIgnoreCase(s);
    }

    public static boolean stringContainsSQLWildcard(String s) {
        if (s == null) {
            return false;
        }
        return s.indexOf(37) != -1 || s.indexOf(95) != -1;
    }

    public static Set<String> tokenize(String in) {
        HashSet<String> answer = new HashSet<String>();
        if (StringUtility.stringHasValue(in)) {
            StringTokenizer st = new StringTokenizer(in, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                answer.add(s);
            }
        }
        return answer;
    }
}

