/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinType;
import org.mybatis.generator.internal.util.StringUtility;

public class CacheNamespacePlugin
extends PluginAdapter {
    @Override
    public boolean validate(List<String> arg0) {
        return true;
    }

    @Override
    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        if (!this.skip(introspectedTable)) {
            interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.CacheNamespace"));
            Arrays.stream(CacheProperty.values()).filter(CacheProperty::isClassName).map(cp -> this.getRawPropertyValue(introspectedTable, cp.getPropertyName())).filter(Optional::isPresent).map(Optional::get).map(FullyQualifiedJavaType::new).forEach(interfaze::addImportedType);
            interfaze.addAnnotation(this.calculateAnnotation(introspectedTable, ".class"));
        }
        return true;
    }

    @Override
    public boolean mapperGenerated(KotlinFile mapperFile, KotlinType mapper, IntrospectedTable introspectedTable) {
        if (!this.skip(introspectedTable)) {
            mapperFile.addImport("org.apache.ibatis.annotations.CacheNamespace");
            Arrays.stream(CacheProperty.values()).filter(CacheProperty::isClassName).map(cp -> this.getRawPropertyValue(introspectedTable, cp.getPropertyName())).filter(Optional::isPresent).map(Optional::get).forEach(mapperFile::addImport);
            mapper.addAnnotation(this.calculateAnnotation(introspectedTable, "::class"));
        }
        return true;
    }

    private boolean skip(IntrospectedTable introspectedTable) {
        return this.getRawPropertyValue(introspectedTable, "cache_skip").map("true"::equalsIgnoreCase).orElse(false);
    }

    private String calculateAnnotation(IntrospectedTable introspectedTable, String classAccessor) {
        String attributes = Arrays.stream(CacheProperty.values()).map(cp -> this.calculateAttribute(introspectedTable, (CacheProperty)((Object)cp), classAccessor)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(", "));
        if (StringUtility.stringHasValue(attributes)) {
            return "@CacheNamespace(" + attributes + ")";
        }
        return "@CacheNamespace";
    }

    private Optional<String> calculateAttribute(IntrospectedTable introspectedTable, CacheProperty cacheProperty, String classAccessor) {
        return this.getPropertyValueForAttribute(introspectedTable, cacheProperty, classAccessor).map(v -> String.format("%s = %s", cacheProperty.getAttributeName(), v));
    }

    private Optional<String> getPropertyValueForAttribute(IntrospectedTable introspectedTable, CacheProperty cacheProperty, String classAccessor) {
        Optional<String> value = this.getRawPropertyValue(introspectedTable, cacheProperty.getPropertyName());
        if (cacheProperty.isClassName()) {
            value = value.map(FullyQualifiedJavaType::new).map(FullyQualifiedJavaType::getShortName).map(s -> s + classAccessor);
        }
        return value;
    }

    private Optional<String> getRawPropertyValue(IntrospectedTable introspectedTable, String propertyName) {
        String value = introspectedTable.getTableConfigurationProperty(propertyName);
        if (value == null) {
            value = this.properties.getProperty(propertyName);
        }
        if (StringUtility.stringHasValue(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static enum CacheProperty {
        BLOCKING("cache_blocking", "blocking", false),
        FLUSH_INTERVAL("cache_flushInterval", "flushInterval", false),
        READ_WRITE("cache_readWrite", "readWrite", false),
        SIZE("cache_size", "size", false),
        IMPLEMENTATION("cache_implementation", "implementation", true),
        EVICTION("cache_eviction", "eviction", true);

        private final String propertyName;
        private final String attributeName;
        private final boolean isClassName;

        private CacheProperty(String propertyName, String attributeName, boolean isClassName) {
            this.propertyName = propertyName;
            this.attributeName = attributeName;
            this.isClassName = isClassName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public boolean isClassName() {
            return this.isClassName;
        }
    }
}

