/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class EqualsHashCodePlugin
extends PluginAdapter {
    private boolean useEqualsHashCodeFromRoot;

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.useEqualsHashCodeFromRoot = StringUtility.isTrue(properties.getProperty("useEqualsHashCodeFromRoot"));
    }

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List<IntrospectedColumn> columns = introspectedTable.getRules().generateRecordWithBLOBsClass() ? introspectedTable.getNonBLOBColumns() : introspectedTable.getAllColumns();
        this.generateEquals(topLevelClass, columns, introspectedTable);
        this.generateHashCode(topLevelClass, columns, introspectedTable);
        return true;
    }

    @Override
    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateEquals(topLevelClass, introspectedTable.getPrimaryKeyColumns(), introspectedTable);
        this.generateHashCode(topLevelClass, introspectedTable.getPrimaryKeyColumns(), introspectedTable);
        return true;
    }

    @Override
    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateEquals(topLevelClass, introspectedTable.getAllColumns(), introspectedTable);
        this.generateHashCode(topLevelClass, introspectedTable.getAllColumns(), introspectedTable);
        return true;
    }

    protected void generateEquals(TopLevelClass topLevelClass, List<IntrospectedColumn> introspectedColumns, IntrospectedTable introspectedTable) {
        Method method = new Method("equals");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "that"));
        method.addAnnotation("@Override");
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            this.context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            this.context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        }
        method.addBodyLine("if (this == that) {");
        method.addBodyLine("return true;");
        method.addBodyLine("}");
        method.addBodyLine("if (that == null) {");
        method.addBodyLine("return false;");
        method.addBodyLine("}");
        method.addBodyLine("if (getClass() != that.getClass()) {");
        method.addBodyLine("return false;");
        method.addBodyLine("}");
        StringBuilder sb = new StringBuilder();
        sb.append(topLevelClass.getType().getShortName());
        sb.append(" other = (");
        sb.append(topLevelClass.getType().getShortName());
        sb.append(") that;");
        method.addBodyLine(sb.toString());
        if (this.useEqualsHashCodeFromRoot && topLevelClass.getSuperClass().isPresent()) {
            method.addBodyLine("if (!super.equals(other)) {");
            method.addBodyLine("return false;");
            method.addBodyLine("}");
        }
        boolean first = true;
        Iterator<IntrospectedColumn> iter = introspectedColumns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = iter.next();
            sb.setLength(0);
            if (first) {
                sb.append("return (");
                first = false;
            } else {
                OutputUtilities.javaIndent(sb, 1);
                sb.append("&& (");
            }
            String getterMethod = JavaBeansUtil.getGetterMethodName(introspectedColumn.getJavaProperty(), introspectedColumn.getFullyQualifiedJavaType());
            if (introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
                sb.append("this.");
                sb.append(getterMethod);
                sb.append("() == ");
                sb.append("other.");
                sb.append(getterMethod);
                sb.append("())");
            } else if (introspectedColumn.getFullyQualifiedJavaType().isArray()) {
                topLevelClass.addImportedType("java.util.Arrays");
                sb.append("Arrays.equals(this.");
                sb.append(getterMethod);
                sb.append("(), ");
                sb.append("other.");
                sb.append(getterMethod);
                sb.append("()))");
            } else {
                sb.append("this.");
                sb.append(getterMethod);
                sb.append("() == null ? other.");
                sb.append(getterMethod);
                sb.append("() == null : this.");
                sb.append(getterMethod);
                sb.append("().equals(other.");
                sb.append(getterMethod);
                sb.append("()))");
            }
            if (!iter.hasNext()) {
                sb.append(';');
            }
            method.addBodyLine(sb.toString());
        }
        topLevelClass.addMethod(method);
    }

    protected void generateHashCode(TopLevelClass topLevelClass, List<IntrospectedColumn> introspectedColumns, IntrospectedTable introspectedTable) {
        Method method = new Method("hashCode");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addAnnotation("@Override");
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            this.context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            this.context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        }
        method.addBodyLine("final int prime = 31;");
        method.addBodyLine("int result = 1;");
        if (this.useEqualsHashCodeFromRoot && topLevelClass.getSuperClass().isPresent()) {
            method.addBodyLine("result = prime * result + super.hashCode();");
        }
        StringBuilder sb = new StringBuilder();
        boolean hasTemp = false;
        for (IntrospectedColumn introspectedColumn : introspectedColumns) {
            FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
            String getterMethod = JavaBeansUtil.getGetterMethodName(introspectedColumn.getJavaProperty(), fqjt);
            sb.setLength(0);
            if (fqjt.isPrimitive()) {
                if ("boolean".equals(fqjt.getFullyQualifiedName())) {
                    sb.append("result = prime * result + (");
                    sb.append(getterMethod);
                    sb.append("() ? 1231 : 1237);");
                    method.addBodyLine(sb.toString());
                    continue;
                }
                if ("byte".equals(fqjt.getFullyQualifiedName())) {
                    sb.append("result = prime * result + ");
                    sb.append(getterMethod);
                    sb.append("();");
                    method.addBodyLine(sb.toString());
                    continue;
                }
                if ("char".equals(fqjt.getFullyQualifiedName())) {
                    sb.append("result = prime * result + ");
                    sb.append(getterMethod);
                    sb.append("();");
                    method.addBodyLine(sb.toString());
                    continue;
                }
                if ("double".equals(fqjt.getFullyQualifiedName())) {
                    if (!hasTemp) {
                        method.addBodyLine("long temp;");
                        hasTemp = true;
                    }
                    sb.append("temp = Double.doubleToLongBits(");
                    sb.append(getterMethod);
                    sb.append("());");
                    method.addBodyLine(sb.toString());
                    method.addBodyLine("result = prime * result + (int) (temp ^ (temp >>> 32));");
                    continue;
                }
                if ("float".equals(fqjt.getFullyQualifiedName())) {
                    sb.append("result = prime * result + Float.floatToIntBits(");
                    sb.append(getterMethod);
                    sb.append("());");
                    method.addBodyLine(sb.toString());
                    continue;
                }
                if ("int".equals(fqjt.getFullyQualifiedName())) {
                    sb.append("result = prime * result + ");
                    sb.append(getterMethod);
                    sb.append("();");
                    method.addBodyLine(sb.toString());
                    continue;
                }
                if ("long".equals(fqjt.getFullyQualifiedName())) {
                    sb.append("result = prime * result + (int) (");
                    sb.append(getterMethod);
                    sb.append("() ^ (");
                    sb.append(getterMethod);
                    sb.append("() >>> 32));");
                    method.addBodyLine(sb.toString());
                    continue;
                }
                if (!"short".equals(fqjt.getFullyQualifiedName())) continue;
                sb.append("result = prime * result + ");
                sb.append(getterMethod);
                sb.append("();");
                method.addBodyLine(sb.toString());
                continue;
            }
            if (fqjt.isArray()) {
                sb.append("result = prime * result + (Arrays.hashCode(");
                sb.append(getterMethod);
                sb.append("()));");
                method.addBodyLine(sb.toString());
                continue;
            }
            sb.append("result = prime * result + ((");
            sb.append(getterMethod);
            sb.append("() == null) ? 0 : ");
            sb.append(getterMethod);
            sb.append("().hashCode());");
            method.addBodyLine(sb.toString());
        }
        method.addBodyLine("return result;");
        topLevelClass.addMethod(method);
    }
}

