/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaClientGenerator;
import org.mybatis.generator.codegen.AbstractXmlGenerator;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.runtime.dynamic.sql.DynamicSqlSupportClassGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.BasicInsertMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.BasicMultipleInsertMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.BasicSelectManyMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.BasicSelectOneMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.DeleteByPrimaryKeyMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.FieldAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.FragmentGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.GeneralCountMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.GeneralDeleteMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.GeneralSelectDistinctMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.GeneralSelectMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.GeneralSelectOneMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.GeneralUpdateMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.InsertMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.InsertMultipleMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.InsertSelectiveMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.SelectByPrimaryKeyMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.SelectListGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.UpdateAllColumnsMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.UpdateByPrimaryKeyMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.UpdateByPrimaryKeySelectiveMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.UpdateSelectiveColumnsMethodGenerator;

public class DynamicSqlMapperGenerator
extends AbstractJavaClientGenerator {
    protected FullyQualifiedJavaType recordType;
    protected String resultMapId;
    protected String tableFieldName;
    protected FragmentGenerator fragmentGenerator;
    protected boolean hasGeneratedKeys;

    public DynamicSqlMapperGenerator(String project) {
        super(project, false);
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        this.progressCallback.startTask(Messages.getString("Progress.17", this.introspectedTable.getFullyQualifiedTable().toString()));
        this.preCalculate();
        Interface interfaze = this.createBasicInterface();
        TopLevelClass supportClass = this.getSupportClass();
        String staticImportString = supportClass.getType().getFullyQualifiedNameWithoutTypeParameters() + ".*";
        interfaze.addStaticImport(staticImportString);
        if (this.hasGeneratedKeys) {
            this.addBasicInsertMethod(interfaze);
            this.addBasicInsertMultipleMethod(interfaze);
        }
        boolean reuseResultMap = this.addBasicSelectManyMethod(interfaze);
        this.addBasicSelectOneMethod(interfaze, reuseResultMap);
        this.addGeneralCountMethod(interfaze);
        this.addGeneralDeleteMethod(interfaze);
        this.addDeleteByPrimaryKeyMethod(interfaze);
        this.addInsertOneMethod(interfaze);
        this.addInsertMultipleMethod(interfaze);
        this.addInsertSelectiveMethod(interfaze);
        this.addSelectListField(interfaze);
        this.addGeneralSelectMethod(interfaze);
        this.addSelectDistinctMethod(interfaze);
        this.addSelectByPrimaryKeyMethod(interfaze);
        this.addGeneralUpdateMethod(interfaze);
        this.addUpdateAllMethod(interfaze);
        this.addUpdateSelectiveMethod(interfaze);
        this.addUpdateByPrimaryKeyMethod(interfaze);
        this.addUpdateByPrimaryKeySelectiveMethod(interfaze);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.context.getPlugins().clientGenerated(interfaze, this.introspectedTable)) {
            answer.add(interfaze);
        }
        if (this.context.getPlugins().dynamicSqlSupportGenerated(supportClass, this.introspectedTable)) {
            answer.add(supportClass);
        }
        return answer;
    }

    protected void preCalculate() {
        this.recordType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
        this.resultMapId = this.recordType.getShortNameWithoutTypeArguments() + "Result";
        this.tableFieldName = JavaBeansUtil.getValidPropertyName(this.introspectedTable.getMyBatisDynamicSQLTableObjectName());
        this.fragmentGenerator = new FragmentGenerator.Builder().withIntrospectedTable(this.introspectedTable).withResultMapId(this.resultMapId).withTableFieldName(this.tableFieldName).build();
        this.hasGeneratedKeys = this.introspectedTable.getGeneratedKey().isPresent();
    }

    protected Interface createBasicInterface() {
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType());
        Interface interfaze = new Interface(type);
        interfaze.setVisibility(JavaVisibility.PUBLIC);
        this.context.getCommentGenerator().addJavaFileComment(interfaze);
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
        interfaze.addAnnotation("@Mapper");
        String rootInterface = this.introspectedTable.getTableConfigurationProperty("rootInterface");
        if (!StringUtility.stringHasValue(rootInterface)) {
            rootInterface = this.context.getJavaClientGeneratorConfiguration().getProperty("rootInterface");
        }
        if (StringUtility.stringHasValue(rootInterface)) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(rootInterface);
            interfaze.addSuperInterface(fqjt);
            interfaze.addImportedType(fqjt);
        }
        return interfaze;
    }

    protected TopLevelClass getSupportClass() {
        return DynamicSqlSupportClassGenerator.of(this.introspectedTable, this.context.getCommentGenerator(), this.warnings).generate();
    }

    protected void addInsertOneMethod(Interface interfaze) {
        InsertMethodGenerator generator = ((InsertMethodGenerator.Builder)((InsertMethodGenerator.Builder)((InsertMethodGenerator.Builder)new InsertMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        if (this.generate(interfaze, generator) && !this.hasGeneratedKeys) {
            this.addCommonInsertInterface(interfaze);
        }
    }

    protected void addCommonInsertInterface(Interface interfaze) {
        FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.mybatis3.CommonInsertMapper<" + this.recordType.getFullyQualifiedName() + ">");
        interfaze.addSuperInterface(superInterface);
        interfaze.addImportedTypes(superInterface.getImportList().stream().map(FullyQualifiedJavaType::new).collect(Collectors.toSet()));
    }

    protected void addBasicInsertMultipleMethod(Interface interfaze) {
        BasicMultipleInsertMethodGenerator generator = ((BasicMultipleInsertMethodGenerator.Builder)((BasicMultipleInsertMethodGenerator.Builder)((BasicMultipleInsertMethodGenerator.Builder)new BasicMultipleInsertMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addInsertMultipleMethod(Interface interfaze) {
        InsertMultipleMethodGenerator generator = ((InsertMultipleMethodGenerator.Builder)((InsertMultipleMethodGenerator.Builder)((InsertMultipleMethodGenerator.Builder)new InsertMultipleMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        if (this.generate(interfaze, generator) && !this.hasGeneratedKeys) {
            this.addCommonInsertInterface(interfaze);
        }
    }

    protected void addGeneralCountMethod(Interface interfaze) {
        GeneralCountMethodGenerator generator = ((GeneralCountMethodGenerator.Builder)((GeneralCountMethodGenerator.Builder)((GeneralCountMethodGenerator.Builder)new GeneralCountMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).build();
        if (this.generate(interfaze, generator)) {
            FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.mybatis3.CommonCountMapper");
            interfaze.addSuperInterface(superInterface);
            interfaze.addImportedType(superInterface);
        }
    }

    protected void addGeneralDeleteMethod(Interface interfaze) {
        GeneralDeleteMethodGenerator generator = ((GeneralDeleteMethodGenerator.Builder)((GeneralDeleteMethodGenerator.Builder)((GeneralDeleteMethodGenerator.Builder)new GeneralDeleteMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).build();
        if (this.generate(interfaze, generator)) {
            FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.mybatis3.CommonDeleteMapper");
            interfaze.addSuperInterface(superInterface);
            interfaze.addImportedType(superInterface);
        }
    }

    protected void addSelectListField(Interface interfaze) {
        SelectListGenerator generator = new SelectListGenerator.Builder().withContext(this.context).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable).build();
        FieldAndImports fieldAndImports = generator.generateFieldAndImports();
        if (fieldAndImports != null && generator.callPlugins(fieldAndImports.getField(), interfaze)) {
            interfaze.addField(fieldAndImports.getField());
            interfaze.addImportedTypes(fieldAndImports.getImports());
        }
    }

    protected void addGeneralSelectMethod(Interface interfaze) {
        this.addGeneralSelectOneMethod(interfaze);
        GeneralSelectMethodGenerator generator = ((GeneralSelectMethodGenerator.Builder)((GeneralSelectMethodGenerator.Builder)((GeneralSelectMethodGenerator.Builder)new GeneralSelectMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addSelectDistinctMethod(Interface interfaze) {
        GeneralSelectDistinctMethodGenerator generator = ((GeneralSelectDistinctMethodGenerator.Builder)((GeneralSelectDistinctMethodGenerator.Builder)((GeneralSelectDistinctMethodGenerator.Builder)new GeneralSelectDistinctMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addGeneralSelectOneMethod(Interface interfaze) {
        GeneralSelectOneMethodGenerator generator = ((GeneralSelectOneMethodGenerator.Builder)((GeneralSelectOneMethodGenerator.Builder)((GeneralSelectOneMethodGenerator.Builder)new GeneralSelectOneMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addGeneralUpdateMethod(Interface interfaze) {
        GeneralUpdateMethodGenerator generator = ((GeneralUpdateMethodGenerator.Builder)((GeneralUpdateMethodGenerator.Builder)((GeneralUpdateMethodGenerator.Builder)new GeneralUpdateMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).build();
        if (this.generate(interfaze, generator)) {
            FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.mybatis3.CommonUpdateMapper");
            interfaze.addSuperInterface(superInterface);
            interfaze.addImportedType(superInterface);
        }
    }

    protected void addUpdateAllMethod(Interface interfaze) {
        UpdateAllColumnsMethodGenerator generator = ((UpdateAllColumnsMethodGenerator.Builder)((UpdateAllColumnsMethodGenerator.Builder)((UpdateAllColumnsMethodGenerator.Builder)new UpdateAllColumnsMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withFragmentGenerator(this.fragmentGenerator).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addUpdateSelectiveMethod(Interface interfaze) {
        UpdateSelectiveColumnsMethodGenerator generator = ((UpdateSelectiveColumnsMethodGenerator.Builder)((UpdateSelectiveColumnsMethodGenerator.Builder)((UpdateSelectiveColumnsMethodGenerator.Builder)new UpdateSelectiveColumnsMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withFragmentGenerator(this.fragmentGenerator).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addBasicSelectOneMethod(Interface interfaze, boolean reuseResultMap) {
        BasicSelectOneMethodGenerator generator = ((BasicSelectOneMethodGenerator.Builder)((BasicSelectOneMethodGenerator.Builder)((BasicSelectOneMethodGenerator.Builder)new BasicSelectOneMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).withResultMapId(this.resultMapId).withReuseResultMap(reuseResultMap).build();
        this.generate(interfaze, generator);
    }

    protected void addDeleteByPrimaryKeyMethod(Interface interfaze) {
        DeleteByPrimaryKeyMethodGenerator generator = ((DeleteByPrimaryKeyMethodGenerator.Builder)((DeleteByPrimaryKeyMethodGenerator.Builder)((DeleteByPrimaryKeyMethodGenerator.Builder)new DeleteByPrimaryKeyMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withFragmentGenerator(this.fragmentGenerator).withTableFieldName(this.tableFieldName)).build();
        this.generate(interfaze, generator);
    }

    protected void addInsertSelectiveMethod(Interface interfaze) {
        InsertSelectiveMethodGenerator generator = ((InsertSelectiveMethodGenerator.Builder)((InsertSelectiveMethodGenerator.Builder)((InsertSelectiveMethodGenerator.Builder)new InsertSelectiveMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        if (this.generate(interfaze, generator) && !this.hasGeneratedKeys) {
            this.addCommonInsertInterface(interfaze);
        }
    }

    protected void addSelectByPrimaryKeyMethod(Interface interfaze) {
        SelectByPrimaryKeyMethodGenerator generator = ((SelectByPrimaryKeyMethodGenerator.Builder)((SelectByPrimaryKeyMethodGenerator.Builder)((SelectByPrimaryKeyMethodGenerator.Builder)new SelectByPrimaryKeyMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addUpdateByPrimaryKeyMethod(Interface interfaze) {
        UpdateByPrimaryKeyMethodGenerator generator = ((UpdateByPrimaryKeyMethodGenerator.Builder)((UpdateByPrimaryKeyMethodGenerator.Builder)((UpdateByPrimaryKeyMethodGenerator.Builder)new UpdateByPrimaryKeyMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addUpdateByPrimaryKeySelectiveMethod(Interface interfaze) {
        UpdateByPrimaryKeySelectiveMethodGenerator generator = ((UpdateByPrimaryKeySelectiveMethodGenerator.Builder)((UpdateByPrimaryKeySelectiveMethodGenerator.Builder)((UpdateByPrimaryKeySelectiveMethodGenerator.Builder)new UpdateByPrimaryKeySelectiveMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected void addBasicInsertMethod(Interface interfaze) {
        BasicInsertMethodGenerator generator = ((BasicInsertMethodGenerator.Builder)((BasicInsertMethodGenerator.Builder)((BasicInsertMethodGenerator.Builder)new BasicInsertMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        this.generate(interfaze, generator);
    }

    protected boolean addBasicSelectManyMethod(Interface interfaze) {
        BasicSelectManyMethodGenerator generator = ((BasicSelectManyMethodGenerator.Builder)((BasicSelectManyMethodGenerator.Builder)((BasicSelectManyMethodGenerator.Builder)new BasicSelectManyMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.tableFieldName)).withRecordType(this.recordType).build();
        return this.generate(interfaze, generator);
    }

    protected boolean generate(Interface interfaze, AbstractMethodGenerator generator) {
        MethodAndImports mi = generator.generateMethodAndImports();
        if (mi != null && generator.callPlugins(mi.getMethod(), interfaze)) {
            interfaze.addMethod(mi.getMethod());
            interfaze.addImportedTypes(mi.getImports());
            interfaze.addStaticImports(mi.getStaticImports());
            return true;
        }
        return false;
    }

    @Override
    public AbstractXmlGenerator getMatchedXMLGenerator() {
        return null;
    }
}

