/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Parameter;

public class MethodParts {
    private final List<String> annotations;
    private final List<String> bodyLines;
    private final Set<FullyQualifiedJavaType> imports;
    private final List<Parameter> parameters;

    private MethodParts(Builder builder) {
        this.imports = builder.imports;
        this.bodyLines = builder.bodyLines;
        this.parameters = builder.parameters;
        this.annotations = builder.annotations;
    }

    public Set<FullyQualifiedJavaType> getImports() {
        return this.imports;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public List<String> getBodyLines() {
        return this.bodyLines;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public static class Builder {
        private final List<String> bodyLines = new ArrayList<String>();
        private final Set<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private final List<String> annotations = new ArrayList<String>();

        public Builder withAnnotation(String annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public Builder withBodyLine(String bodyLine) {
            this.bodyLines.add(bodyLine);
            return this;
        }

        public Builder withImport(FullyQualifiedJavaType importedType) {
            this.imports.add(importedType);
            return this;
        }

        public Builder withImports(Set<FullyQualifiedJavaType> imports) {
            this.imports.addAll(imports);
            return this;
        }

        public Builder withParameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public MethodParts build() {
            return new MethodParts(this);
        }
    }
}

