/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.nutz.dao.Chain;
import org.nutz.dao.Condition;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.Dao;
import org.nutz.dao.DaoException;
import org.nutz.dao.FieldFilter;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.Sqls;
import org.nutz.dao.TableName;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityIndex;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.entity.field.ManyManyLinkField;
import org.nutz.dao.impl.sql.SqlFormat;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.util.ExtDaoInvocationHandler;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.Callback2;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.Scans;
import org.nutz.trans.Molecule;
import org.nutz.trans.Trans;

public abstract class Daos {
    private static final Log log = Logs.get();
    private static Class<?>[] iz = new Class[]{Dao.class};
    private static SqlFormat sqlFormat = SqlFormat.full;
    public static boolean CHECK_COLUMN_NAME_KEYWORD = false;
    public static boolean FORCE_WRAP_COLUMN_NAME = false;
    public static boolean FORCE_UPPER_COLUMN_NAME = false;
    public static int DEFAULT_VARCHAR_WIDTH = 128;

    public static void safeClose(Statement stat, ResultSet rs) {
        Daos.safeClose(rs);
        Daos.safeClose(stat);
    }

    public static void safeClose(Statement stat) {
        if (null != stat) {
            try {
                stat.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getColumnIndex(ResultSetMetaData meta, String colName) throws SQLException {
        if (meta == null) {
            return 0;
        }
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnName(i).equalsIgnoreCase(colName)) continue;
            return i;
        }
        log.infof("Can not find @Column(%s) in table/view (%s)", colName, meta.getTableName(1));
        throw Lang.makeThrow(SQLException.class, "Can not find @Column(%s)", colName);
    }

    public static boolean isIntLikeColumn(ResultSetMetaData meta, int index) throws SQLException {
        switch (meta.getColumnType(index)) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static Pager updatePagerCount(Pager pager, Dao dao, Class<?> entityType, Condition cnd) {
        if (null != pager) {
            pager.setRecordCount(dao.count(entityType, cnd));
        }
        return pager;
    }

    public static Pager updatePagerCount(Pager pager, Dao dao, String tableName, Condition cnd) {
        if (null != pager) {
            pager.setRecordCount(dao.count(tableName, cnd));
        }
        return pager;
    }

    public static <T> List<T> queryList(Dao dao, Class<T> klass, String sql_str) {
        Sql sql = Sqls.create(sql_str).setCallback(Sqls.callback.entities()).setEntity(dao.getEntity(klass));
        dao.execute(sql);
        return sql.getList(klass);
    }

    public static Object query(Dao dao, String sql_str, SqlCallback callback) {
        Sql sql = Sqls.create(sql_str).setCallback(callback);
        dao.execute(sql);
        return sql.getResult();
    }

    public static <T> List<T> queryWithLinks(final Dao dao, final Class<T> classOfT, final Condition cnd, final Pager pager, final String regex) {
        Molecule molecule = new Molecule<List<T>>(){

            @Override
            public void run() {
                List list = dao.query(classOfT, cnd, pager);
                for (Object t : list) {
                    dao.fetchLinks(t, regex);
                }
                this.setObj(list);
            }
        };
        return (List)Trans.exec(molecule);
    }

    public static StringBuilder dataDict(DataSource ds, String ... packages) {
        Method evalFieldType;
        StringBuilder sb = new StringBuilder();
        ArrayList ks = new ArrayList();
        for (String packageName : packages) {
            ks.addAll(Scans.me().scanPackage(packageName));
        }
        Iterator it = ks.iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (klass.getAnnotation(Table.class) != null) continue;
            it.remove();
        }
        JdbcExpert exp = Jdbcs.getExpert(ds);
        NutDao dao = new NutDao(ds);
        try {
            evalFieldType = exp.getClass().getDeclaredMethod("evalFieldType", MappingField.class);
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
        evalFieldType.setAccessible(true);
        Entity entity = null;
        String line = "-------------------------------------------------------------------\n";
        sb.append("#title:\u6570\u636e\u5b57\u5178\n");
        sb.append("#author:wendal\n");
        sb.append("#index:0,1\n").append(line);
        for (Class clazz : ks) {
            sb.append(line);
            entity = dao.getEntity(clazz);
            sb.append("\u8868\u540d ").append(entity.getTableName()).append("\n\n");
            if (!Strings.isBlank(entity.getTableComment())) {
                sb.append("\u8868\u6ce8\u91ca: ").append(entity.getTableComment());
            }
            sb.append("\t").append("Java\u7c7b\u540d ").append(clazz.getName()).append("\n\n");
            sb.append("\t||\u5e8f\u53f7||\u5217\u540d||\u6570\u636e\u7c7b\u578b||\u4e3b\u952e||\u975e\u7a7a||\u9ed8\u8ba4\u503c||java\u5c5e\u6027\u540d||java\u7c7b\u578b||\u6ce8\u91ca||\n");
            int index = 1;
            for (MappingField field : entity.getMappingFields()) {
                String dataType;
                try {
                    dataType = (String)evalFieldType.invoke((Object)exp, field);
                }
                catch (Throwable e) {
                    throw Lang.wrapThrow(e);
                }
                sb.append("\t||").append(index++).append("||").append(field.getColumnName()).append("||").append(dataType).append("||").append(field.isPk()).append("||").append(field.isNotNull()).append("||").append(field.getDefaultValue(null) == null ? " " : field.getDefaultValue(null)).append("||").append(field.getName()).append("||").append(field.getTypeClass().getName()).append("||").append(field.getColumnComment() == null ? " " : field.getColumnComment()).append("||\n");
            }
        }
        return sb;
    }

    public static <T> List<T> query(Dao dao, Class<T> classOfT, String sql, Condition cnd, Pager pager) {
        Sql sql2 = Sqls.queryEntity(sql);
        sql2.setEntity(dao.getEntity(classOfT));
        sql2.setCondition(cnd);
        sql2.setPager(pager);
        dao.execute(sql2);
        return sql2.getList(classOfT);
    }

    public static long queryCount(Dao dao, String sql) {
        String tmpTable = "as _nutz_tmp";
        tmpTable = dao.meta().isDB2() ? "as nutz_tmp_" + R.UU32() : (dao.meta().isOracle() ? "" : tmpTable + "_" + R.UU32());
        Sql sql2 = Sqls.fetchInt("select count(1) from (" + sql + ")" + tmpTable);
        dao.execute(sql2);
        return sql2.getInt();
    }

    public static int updateBySpecialChain(Dao dao, Entity en, String tableName, Chain chain, Condition cnd) {
        if (en != null) {
            tableName = en.getTableName();
        }
        if (tableName == null) {
            throw Lang.makeThrow(DaoException.class, "tableName and en is NULL !!", new Object[0]);
        }
        final StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        Chain head = chain.head();
        final ArrayList<Object> values = new ArrayList<Object>();
        final ArrayList<ValueAdaptor> adaptors = new ArrayList<ValueAdaptor>();
        while (head != null) {
            MappingField mf = null;
            if (en != null) {
                mf = en.getField(head.name());
            }
            String colName = head.name();
            if (mf != null) {
                colName = mf.getColumnNameInSql();
            }
            sql.append(colName).append("=");
            if (head.special()) {
                String str;
                if (head.value() != null && head.value() instanceof String && (str = (String)head.value()).length() > 0) {
                    switch (str.charAt(0)) {
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '^': 
                        case '|': {
                            sql.append(colName);
                        }
                    }
                }
                sql.append(head.value());
            } else {
                sql.append("?");
                values.add(head.value());
                ValueAdaptor adaptor = Jdbcs.getAdaptorBy(head.value());
                if (mf != null && mf.getAdaptor() != null) {
                    adaptor = mf.getAdaptor();
                }
                adaptors.add(adaptor);
            }
            sql.append(" ");
            if ((head = head.next()) == null) continue;
            sql.append(", ");
        }
        if (cnd != null) {
            sql.append(" ").append(cnd.toSql(en));
        }
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        final int[] ints = new int[1];
        dao.run(new ConnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Connection conn) throws Exception {
                PreparedStatement ps = conn.prepareStatement(sql.toString());
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        ((ValueAdaptor)adaptors.get(i)).set(ps, values.get(i), i + 1);
                    }
                    ints[0] = ps.executeUpdate();
                }
                finally {
                    Daos.safeClose(ps);
                }
            }
        });
        return ints[0];
    }

    public static void insertBySpecialChain(Dao dao, Entity en, String tableName, Chain chain) {
        if (en != null) {
            tableName = en.getTableName();
        }
        if (tableName == null) {
            throw Lang.makeThrow(DaoException.class, "tableName and en is NULL !!", new Object[0]);
        }
        final StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        StringBuilder _value_places = new StringBuilder(" VALUES(");
        final ArrayList<Object> values = new ArrayList<Object>();
        final ArrayList<ValueAdaptor> adaptors = new ArrayList<ValueAdaptor>();
        Chain head = chain.head();
        while (head != null) {
            String colName = head.name();
            MappingField mf = null;
            if (en != null && (mf = en.getField(colName)) != null) {
                colName = mf.getColumnNameInSql();
            }
            sql.append(colName);
            if (head.special()) {
                _value_places.append(head.value());
            } else {
                if (en != null) {
                    mf = en.getField(head.name());
                }
                _value_places.append("?");
                values.add(head.value());
                ValueAdaptor adaptor = Jdbcs.getAdaptorBy(head.value());
                if (mf != null && mf.getAdaptor() != null) {
                    adaptor = mf.getAdaptor();
                }
                adaptors.add(adaptor);
            }
            if ((head = head.next()) == null) continue;
            sql.append(", ");
            _value_places.append(", ");
        }
        sql.append(")");
        _value_places.append(")");
        sql.append((CharSequence)_value_places);
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        dao.run(new ConnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Connection conn) throws Exception {
                PreparedStatement ps = conn.prepareStatement(sql.toString());
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        ((ValueAdaptor)adaptors.get(i)).set(ps, values.get(i), i + 1);
                    }
                    ps.execute();
                }
                finally {
                    Daos.safeClose(ps);
                }
            }
        });
    }

    public static void createTablesInPackage(Dao dao, String packageName, boolean force) {
        ArrayList list = new ArrayList();
        block0: for (Class<Object> klass : Scans.me().scanPackage(packageName)) {
            if (klass.getAnnotation(Table.class) == null) continue;
            Entity<?> en = dao.getEntity(klass);
            List<LinkField> tmp = en.getLinkFields(null);
            if (tmp != null && tmp.size() > 0) {
                for (LinkField lf : tmp) {
                    if (!(lf instanceof ManyManyLinkField)) continue;
                    list.add(0, klass);
                    continue block0;
                }
            }
            list.add(klass);
        }
        for (Class<Object> klass : list) {
            dao.create(klass, force);
        }
    }

    public static void createTablesInPackage(Dao dao, Class<?> oneClzInPackage, boolean force) {
        Daos.createTablesInPackage(dao, oneClzInPackage.getPackage().getName(), force);
    }

    public static Dao ext(Dao dao, FieldFilter filter) {
        return Daos.ext(dao, filter, null);
    }

    public static Dao ext(Dao dao, Object tableName) {
        return Daos.ext(dao, null, tableName);
    }

    public static Dao ext(Dao dao, FieldFilter filter, Object tableName) {
        if (tableName == null && filter == null) {
            return dao;
        }
        ExtDaoInvocationHandler handler = new ExtDaoInvocationHandler(dao, filter, tableName);
        return (Dao)Proxy.newProxyInstance(dao.getClass().getClassLoader(), iz, (InvocationHandler)handler);
    }

    public static boolean filterFields(Object obj, FieldMatcher matcher, Dao dao, Callback2<MappingField, Object> callback) {
        if (obj == null) {
            return false;
        }
        if ((obj = Lang.first(obj)) == null) {
            return false;
        }
        if (obj.getClass() == Class.class) {
            throw Lang.impossible();
        }
        if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
            throw Lang.impossible();
        }
        Entity<?> en = dao.getEntity(obj.getClass());
        if (en == null) {
            throw Lang.impossible();
        }
        ArrayList<MappingField> mfs = new ArrayList<MappingField>(en.getMappingFields());
        if (matcher != null) {
            Iterator it = mfs.iterator();
            while (it.hasNext()) {
                MappingField mf = (MappingField)it.next();
                if (matcher.match(mf.getName())) continue;
                it.remove();
            }
        }
        boolean flag = false;
        for (MappingField mf : mfs) {
            Object val;
            if (matcher == null) {
                val = mf.getValue(obj);
                callback.invoke(mf, val);
                flag = true;
                continue;
            }
            if (matcher.isIgnoreId() && mf.isId() || matcher.isIgnoreName() && mf.isName() || matcher.isIgnorePk() && mf.isCompositePk()) continue;
            val = mf.getValue(obj);
            if (val == null) {
                if (matcher.isIgnoreNull()) {
                    continue;
                }
            } else {
                if (matcher.isIgnoreZero() && val instanceof Number && ((Number)val).doubleValue() == 0.0 || matcher.isIgnoreDate() && val instanceof Date) continue;
                if (!matcher.isIgnoreBlankStr() || val instanceof String) {
                    // empty if block
                }
            }
            callback.invoke(mf, val);
            flag = true;
        }
        return flag;
    }

    public static void migration(Dao dao, Class<?> klass, boolean add, boolean del, boolean checkIndex) {
        Daos.migration(dao, klass, add, del, checkIndex, null);
    }

    public static void migration(Dao dao, Class<?> klass, boolean add, boolean del) {
        Daos.migration(dao, klass, add, del, false, null);
    }

    public static void migration(Dao dao, Class<?> klass, boolean add, boolean del, Object tableName) {
        Daos.migration(dao, klass, add, del, false, tableName);
    }

    public static void migration(Dao dao, Class<?> klass, final boolean add, final boolean del, final boolean checkIndex, Object tableName) {
        Sql[] addIndexSqls;
        Object delIndexSqls;
        final JdbcExpert expert = dao.getJdbcExpert();
        if (tableName != null && Strings.isNotBlank(tableName.toString())) {
            dao = Daos.ext(dao, tableName);
        }
        final Entity<?> en = dao.getEntity(klass);
        if (!dao.exists(klass)) {
            return;
        }
        final ArrayList sqls = new ArrayList();
        final HashSet<String> _indexs = new HashSet<String>();
        dao.run(new ConnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Connection conn) throws Exception {
                expert.setupEntityField(conn, en);
                Statement stat = null;
                ResultSet rs = null;
                ResultSetMetaData meta = null;
                try {
                    stat = conn.createStatement();
                    rs = stat.executeQuery("select * from " + en.getTableName() + " where 1 != 1");
                    meta = rs.getMetaData();
                    HashSet<String> columnNames = new HashSet<String>();
                    int columnCount = meta.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        columnNames.add(meta.getColumnName(i).toLowerCase());
                    }
                    for (MappingField mf : en.getMappingFields()) {
                        if (mf.isReadonly()) continue;
                        String colName = mf.getColumnName();
                        if (columnNames.contains(colName.toLowerCase())) {
                            columnNames.remove(colName.toLowerCase());
                            continue;
                        }
                        if (!add) continue;
                        log.infof("add column[%s] to table[%s]", mf.getColumnName(), en.getTableName());
                        sqls.add(expert.createAddColumnSql(en, mf));
                    }
                    if (del) {
                        for (String colName : columnNames) {
                            log.infof("del column[%s] from table[%s]", colName, en.getTableName());
                            Sql sql = Sqls.create("ALTER table $table DROP column $name");
                            sql.vars().set("table", en.getTableName());
                            sql.vars().set("name", colName);
                            sqls.add(sql);
                        }
                    }
                    if (checkIndex) {
                        _indexs.addAll(expert.getIndexNames(en, conn));
                    }
                    Daos.safeClose(stat, rs);
                }
                catch (SQLException e) {
                    if (log.isDebugEnabled()) {
                        log.debugf("migration Table '%s' fail!", en.getTableName(), e);
                    }
                }
                finally {
                    Daos.safeClose(stat, rs);
                }
            }
        });
        UpdateIndexSql indexSqls = Daos.createIndexs(dao, en, _indexs, tableName);
        if (checkIndex && !Lang.isEmptyArray(delIndexSqls = indexSqls.getSqlsDel())) {
            dao.execute((Sql[])delIndexSqls);
        }
        for (Sql sql : sqls) {
            dao.execute(sql);
        }
        if (checkIndex && !Lang.isEmptyArray(addIndexSqls = indexSqls.getSqlsAdd())) {
            dao.execute(addIndexSqls);
        }
        dao.getJdbcExpert().createRelation(dao, en);
    }

    private static UpdateIndexSql createIndexs(Dao dao, Entity<?> en, Set<String> indexsHis, Object t) {
        UpdateIndexSql uis = new UpdateIndexSql();
        ArrayList<Sql> sqls = new ArrayList<Sql>();
        ArrayList delIndexs = new ArrayList();
        List<EntityIndex> indexs = en.getIndexes();
        for (EntityIndex index : indexs) {
            sqls.add(dao.getJdbcExpert().createIndexSql(en, index));
        }
        if (!Lang.isEmpty(sqls)) {
            uis.setSqlsAdd(sqls.toArray(new Sql[0]));
        }
        Iterator<String> iterator = indexsHis.iterator();
        ArrayList<Sql> delSqls = new ArrayList<Sql>();
        while (iterator.hasNext()) {
            MappingField mf;
            String index = iterator.next();
            if (delIndexs.contains(index) || Lang.equals("PRIMARY", index) || (mf = en.getColumn(index)) != null && mf.isName()) continue;
            delSqls.add(Sqls.createf("ALTER TABLE %s DROP INDEX %s", Daos.getTableName(dao, en, t), index));
        }
        if (!Lang.isEmpty(delSqls)) {
            uis.setSqlsDel((Sql[])Lang.collection2array(delSqls));
        }
        return uis;
    }

    public static void migration(Dao dao, String packageName, boolean add, boolean del, boolean checkIndex, Object nameTable) {
        for (Class<?> klass : Scans.me().scanPackage(packageName)) {
            if (klass.getAnnotation(Table.class) == null) continue;
            Daos.migration(dao, klass, add, del, checkIndex, nameTable);
        }
    }

    public static void migration(Dao dao, String packageName, boolean add, boolean del, Object nameTable) {
        Daos.migration(dao, packageName, add, del, true, nameTable);
    }

    public static void migration(Dao dao, String packageName, boolean add, boolean del, boolean checkIndex) {
        for (Class<?> klass : Scans.me().scanPackage(packageName)) {
            if (klass.getAnnotation(Table.class) == null) continue;
            Daos.migration(dao, klass, add, del, checkIndex, null);
        }
    }

    public static void migration(Dao dao, String packageName, boolean add, boolean del) {
        Daos.migration(dao, packageName, add, del, true);
    }

    public static void checkTableColumn(Dao dao, Object tableName, final Class<?> clsType) {
        final NutDao d = (NutDao)dao;
        final JdbcExpert expert = d.getJdbcExpert();
        Daos.ext((Dao)d, tableName).run(new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                Entity en = d.getEntity(clsType);
                expert.setupEntityField(conn, en);
            }
        });
    }

    public static String getTableName(Dao dao, Class<?> klass, Object target) {
        return Daos.getTableName(dao, dao.getEntity(klass), target);
    }

    public static String getTableName(Dao dao, final Entity<?> en, Object target) {
        if (target == null) {
            return en.getTableName();
        }
        final String[] name = new String[1];
        TableName.run(target, new Runnable(){

            @Override
            public void run() {
                name[0] = en.getTableName();
            }
        });
        return name[0];
    }

    public static SqlFormat getSqlFormat() {
        return sqlFormat;
    }

    public static void setSqlFormat(SqlFormat sqlFormat) {
        Daos.sqlFormat = sqlFormat;
    }

    public static Set<String> sql2003Keywords() {
        HashSet<String> keywords = new HashSet<String>();
        String k = "ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASENSITIVE,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEGIN,BETWEEN,BIGINT,BINARY,BLOB,BOOLEAN,BOTH,BY,CALL,CALLED,CASCADED,CASE,CAST,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLUMN,COMMIT,CONDITION,CONNECT,CONSTRAINT,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DELETE,DEREF,DESCRIBE,DETERMINISTIC,DISCONNECT,DISTINCT,DO,DOUBLE,DROP,DYNAMIC,EACH,ELEMENT,ELSE,ELSEIF,END,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FLOAT,FOR,FOREIGN,FREE,FROM,FULL,FUNCTION,GET,GLOBAL,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ITERATE,JOIN,LANGUAGE,LARGE,LATERAL,LEADING,LEAVE,LEFT,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOOP,MATCH,MEMBER,MERGE,METHOD,MINUTE,MODIFIES,MODULE,MONTH,MULTISET,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NO,NONE,NOT,NULL,NUMERIC,OF,OLD,ON,ONLY,OPEN,OR,ORDER,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PARAMETER,PARTITION,PRECISION,PREPARE,PROCEDURE,RANGE,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELEASE,REPEAT,RESIGNAL,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLLBACK,ROLLUP,ROW,ROWS,SAVEPOINT,SCOPE,SCROLL,SEARCH,SECOND,SELECT,SENSITIVE,SESSION_USER,SET,SIGNAL,SIMILAR,SMALLINT,SOME,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATIC,SUBMULTISET,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TABLESAMPLE,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSLATION,TREAT,TRIGGER,TRUE,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,YEAR";
        for (String keyword : k.split(",")) {
            keywords.add(keyword);
        }
        keywords.remove("VALUE");
        keywords.remove("SQL");
        keywords.remove("YEAR");
        return keywords;
    }

    static class UpdateIndexSql {
        private Sql[] sqlsAdd;
        private Sql[] sqlsDel;

        UpdateIndexSql() {
        }

        public Sql[] getSqlsAdd() {
            return this.sqlsAdd;
        }

        public void setSqlsAdd(Sql[] sqlsAdd) {
            this.sqlsAdd = sqlsAdd;
        }

        public Sql[] getSqlsDel() {
            return this.sqlsDel;
        }

        public void setSqlsDel(Sql[] sqlsDel) {
            this.sqlsDel = sqlsDel;
        }
    }
}

