/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.ObjectProxy;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ScopeContext
implements IocContext {
    private static final Log log = Logs.get();
    private String scope;
    private Map<String, ObjectProxy> objs;

    public ScopeContext(String scope) {
        this.scope = scope;
        this.objs = new LinkedHashMap<String, ObjectProxy>();
    }

    private void checkBuffer() {
        if (null == this.objs) {
            throw Lang.makeThrow("Context '%s' had been deposed!", this.scope);
        }
    }

    public Map<String, ObjectProxy> getObjs() {
        return this.objs;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public ObjectProxy fetch(String name) {
        this.checkBuffer();
        return this.objs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String scope, String name, ObjectProxy obj) {
        if (this.accept(scope)) {
            this.checkBuffer();
            ScopeContext scopeContext = this;
            synchronized (scopeContext) {
                if (!this.objs.containsKey(name)) {
                    if (log.isDebugEnabled()) {
                        log.debugf("Save object '%s' to [%s] ", name, scope);
                    }
                    this.objs.put(name, obj);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean accept(String scope) {
        return null != scope && this.scope.equals(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String scope, String name) {
        if (this.accept(scope)) {
            this.checkBuffer();
            ScopeContext scopeContext = this;
            synchronized (scopeContext) {
                if (this.objs.containsKey(name)) {
                    if (log.isDebugEnabled()) {
                        log.debugf("Remove object '%s' from [%s] ", name, scope);
                    }
                    return null != this.objs.remove(name);
                }
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.checkBuffer();
        ArrayList<Map.Entry<String, ObjectProxy>> list = new ArrayList<Map.Entry<String, ObjectProxy>>(this.objs.entrySet());
        Collections.reverse(list);
        ArrayList<Map.Entry> tmp = new ArrayList<Map.Entry>();
        for (Map.Entry entry : list) {
            try {
                ObjectProxy op = (ObjectProxy)entry.getValue();
                Object obj = op.getObj();
                if (obj != null && obj instanceof DataSource) {
                    tmp.add(entry);
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debugf("Depose object '%s' ...", entry.getKey());
            }
            ((ObjectProxy)entry.getValue()).depose();
        }
        for (Map.Entry entry : tmp) {
            if (log.isDebugEnabled()) {
                log.debugf("Depose object '%s' ...", entry.getKey());
            }
            ((ObjectProxy)entry.getValue()).depose();
        }
        this.objs.clear();
    }

    @Override
    public void depose() {
        if (this.objs != null) {
            this.clear();
            this.objs = null;
        } else if (log.isWarnEnabled()) {
            log.warn("can't depose twice , skip");
        }
    }

    @Override
    public Set<String> names() {
        return this.objs.keySet();
    }
}

