/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.combo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nutz.aop.interceptor.async.AsyncAopIocLoader;
import org.nutz.aop.interceptor.ioc.TransIocLoader;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.loader.annotation.AnnotationIocLoader;
import org.nutz.ioc.loader.json.JsonLoader;
import org.nutz.ioc.loader.properties.PropertiesIocLoader;
import org.nutz.ioc.loader.xml.XmlIocLoader;
import org.nutz.ioc.meta.IocObject;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ComboIocLoader
implements IocLoader {
    private static final Log log = Logs.get();
    private List<IocLoader> iocLoaders = new ArrayList<IocLoader>();
    protected static Map<String, Class<? extends IocLoader>> loaders = new HashMap<String, Class<? extends IocLoader>>();

    public ComboIocLoader(String ... args) throws ClassNotFoundException {
        if (loaders.isEmpty()) {
            loaders.put("js", JsonLoader.class);
            loaders.put("json", JsonLoader.class);
            loaders.put("xml", XmlIocLoader.class);
            loaders.put("annotation", AnnotationIocLoader.class);
            loaders.put("anno", AnnotationIocLoader.class);
            loaders.put("trans", TransIocLoader.class);
            loaders.put("tx", TransIocLoader.class);
            loaders.put("props", PropertiesIocLoader.class);
            loaders.put("properties", PropertiesIocLoader.class);
            loaders.put("async", AsyncAopIocLoader.class);
        }
        ArrayList<String> argsList = null;
        String currentClassName = null;
        for (String str : args) {
            if (str.length() > 0 && str.charAt(0) == '*') {
                if (argsList != null) {
                    this.createIocLoader(currentClassName, (List<String>)argsList);
                }
                currentClassName = str.substring(1);
                argsList = new ArrayList<String>();
                continue;
            }
            if (argsList == null) {
                throw new IllegalArgumentException("ioc args without Loader ClassName. " + Arrays.toString(args));
            }
            argsList.add(str);
        }
        if (currentClassName != null) {
            this.createIocLoader(currentClassName, argsList);
        }
        HashSet<String> beanNames = new HashSet<String>();
        for (IocLoader loader : this.iocLoaders) {
            for (String beanName : loader.getName()) {
                if (beanNames.add(beanName) || !log.isWarnEnabled()) continue;
                log.warnf("Found Duplicate beanName=%s, pls check you config! loader=%s", beanName, loader.getClass());
            }
        }
    }

    private void createIocLoader(String className, List<String> args) throws ClassNotFoundException {
        Class<IocLoader> klass = loaders.get(className);
        if (klass == null) {
            if (!className.contains(".")) {
                HashSet<String> _names = new HashSet<String>();
                String uccp = Strings.upperFirst(className);
                _names.add(String.format("org.nutz.integration.%s.%sIocLoader", className, uccp));
                _names.add(String.format("org.nutz.integration.%s.%sAopConfigure", className, uccp));
                _names.add(String.format("org.nutz.plugins.%s.%sIocLoader", className, uccp));
                _names.add(String.format("org.nutz.plugins.%s.%sAopConfigure", className, uccp));
                for (String _className : _names) {
                    klass = Lang.loadClassQuite(_className);
                    if (klass == null) continue;
                    log.debug("found " + _className + " -- " + _className);
                    break;
                }
            }
            if (klass == null) {
                klass = Lang.loadClass(className);
            }
        }
        this.iocLoaders.add((IocLoader)((Object)Mirror.me(klass).born(args.toArray(new Object[args.size()]))));
    }

    public ComboIocLoader(IocLoader ... loaders) {
        for (IocLoader iocLoader : loaders) {
            if (iocLoader == null) continue;
            this.iocLoaders.add(iocLoader);
        }
    }

    @Override
    public String[] getName() {
        ArrayList<String> list = new ArrayList<String>();
        for (IocLoader iocLoader : this.iocLoaders) {
            for (String name : iocLoader.getName()) {
                list.add(name);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean has(String name) {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            IocObject iocObject = iocLoader.load(loading, name);
            if (log.isDebugEnabled()) {
                String printName;
                if (iocLoader instanceof AnnotationIocLoader) {
                    String packages = Arrays.toString(((AnnotationIocLoader)iocLoader).getPackages());
                    printName = "AnnotationIocLoader(packages=" + packages + ")";
                } else if (JsonLoader.class.equals(iocLoader.getClass()) && ((JsonLoader)iocLoader).getPaths() != null) {
                    String paths = Arrays.toString(((JsonLoader)iocLoader).getPaths());
                    printName = "JsonLoader(paths=" + paths + ")";
                } else {
                    printName = iocLoader.getClass().getSimpleName() + "@" + iocLoader.hashCode();
                }
                log.debugf("Found IocObject(%s) in %s", name, printName);
            }
            return iocObject;
        }
        throw new ObjectLoadException("Object '" + name + "' without define!");
    }

    public void addLoader(IocLoader loader) {
        if (null != loader) {
            if (this.iocLoaders.contains(loader)) {
                return;
            }
            this.iocLoaders.add(loader);
            if (log.isInfoEnabled()) {
                log.infof("add loader : %s : \n     - %s", loader.getClass(), Lang.concat((Object)"\n     - ", loader.getName()));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*ComboIocLoader*/\n{");
        for (IocLoader loader : this.iocLoaders) {
            String str = Json.toJson(loader);
            str = str.replaceFirst("[{]", "");
            int index = str.lastIndexOf("}");
            StringBuilder sb2 = new StringBuilder(str);
            sb2.setCharAt(index, ' ');
            sb.append((CharSequence)sb2).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

