/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.hardware;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.hardware.NetworkItem;
import org.nutz.lang.hardware.NetworkType;

public class Networks {
    private static Map<NetworkType, String> ntMap = new HashMap<NetworkType, String>();

    public static Map<String, NetworkItem> networkItems() {
        HashMap<String, NetworkItem> netFaces = new HashMap<String, NetworkItem>();
        try {
            Enumeration<NetworkInterface> network = NetworkInterface.getNetworkInterfaces();
            while (network.hasMoreElements()) {
                List<InterfaceAddress> addrs;
                NetworkItem netItem = new NetworkItem();
                NetworkInterface face = network.nextElement();
                byte[] data = face.getHardwareAddress();
                try {
                    if (data != null && data.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : data) {
                            sb.append(Strings.toHex(b, 2));
                        }
                        netItem.setMac(sb.toString().toUpperCase());
                        if (netItem.getMac().startsWith("000000000")) {
                            continue;
                        }
                    }
                }
                catch (Throwable sb) {
                    // empty catch block
                }
                if ((addrs = face.getInterfaceAddresses()) != null && !addrs.isEmpty()) {
                    Object object = addrs.iterator();
                    while (object.hasNext()) {
                        InterfaceAddress interfaceAddress = (InterfaceAddress)object.next();
                        String ip = interfaceAddress.getAddress().getHostAddress();
                        if (ip == null || ip.length() == 0) continue;
                        if (ip.contains(".")) {
                            netItem.setIpv4(ip);
                            continue;
                        }
                        netItem.setIpv6(ip);
                    }
                }
                netItem.setMtu(face.getMTU());
                netItem.setDisplay(face.getDisplayName());
                if (netItem.getIpv4() == null && netItem.getMac() == null && netItem.getMtu() < 1) continue;
                netFaces.put(face.getName(), netItem);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Lang.isWin() && netFaces.size() > 0) {
            for (Map.Entry en : netFaces.entrySet()) {
                NetworkItem item = (NetworkItem)en.getValue();
                if (item == null || !Networks.ipOk(item.getIpv4()) || !item.getIpv4().startsWith("10.")) continue;
                netFaces.put("tun0", item);
                break;
            }
        }
        return netFaces;
    }

    public static String ipv4() {
        String ip;
        Map<String, NetworkItem> items = Networks.networkItems();
        for (int i = 0; i < 10; ++i) {
            NetworkItem item = items.get("eth" + i);
            if (item == null || !Networks.ipOk(ip = item.getIpv4())) continue;
            return ip;
        }
        for (NetworkItem item : items.values()) {
            ip = item.getIpv4();
            if (!Networks.ipOk(ip)) continue;
            return ip;
        }
        return null;
    }

    public static String ipv4(NetworkType nt) {
        Map<String, NetworkItem> netFaces = Networks.networkItems();
        if (netFaces.isEmpty()) {
            return null;
        }
        List<NetworkItem> list = Networks.getNetworkByTypes(netFaces, ntMap.get((Object)nt));
        for (NetworkItem item : list) {
            if (Strings.isBlank(item.getIpv4())) continue;
            return item.getIpv4();
        }
        return null;
    }

    public static String mac() {
        NetworkItem networkItem = Networks.firstNetwokrItem();
        if (networkItem == null) {
            return null;
        }
        return networkItem.getMac();
    }

    public static String mac(NetworkType nt) {
        Map<String, NetworkItem> netFaces = Networks.networkItems();
        if (netFaces.isEmpty()) {
            return null;
        }
        List<NetworkItem> list = Networks.getNetworkByTypes(netFaces, ntMap.get((Object)nt));
        for (NetworkItem item : list) {
            if (Strings.isBlank(item.getMac())) continue;
            return item.getMac();
        }
        return null;
    }

    private static NetworkItem firstNetwokrItem() {
        Map<String, NetworkItem> netFaces = Networks.networkItems();
        if (netFaces.isEmpty()) {
            return null;
        }
        List<NetworkItem> re = null;
        re = Networks.getNetworkByTypes(netFaces, ntMap.get((Object)NetworkType.LAN));
        if (re.isEmpty()) {
            re = Networks.getNetworkByTypes(netFaces, ntMap.get((Object)NetworkType.WIFI));
        }
        if (re.isEmpty()) {
            re = Networks.getNetworkByTypes(netFaces, ntMap.get((Object)NetworkType.ThreeG));
        }
        if (re.isEmpty()) {
            re = Networks.getNetworkByTypes(netFaces, ntMap.get((Object)NetworkType.VPN));
        }
        if (re.isEmpty()) {
            for (Map.Entry<String, NetworkItem> en : netFaces.entrySet()) {
                if (Strings.isBlank(en.getValue().getIpv4()) || Strings.isBlank(en.getValue().getMac())) continue;
                return en.getValue();
            }
        }
        return re.get(0);
    }

    private static List<NetworkItem> getNetworkByTypes(Map<String, NetworkItem> netFaces, String nt) {
        String[] nss;
        ArrayList<NetworkItem> list = new ArrayList<NetworkItem>();
        for (String ns : nss = Strings.splitIgnoreBlank(nt, ",")) {
            for (int i = 0; i < 10; ++i) {
                if (!netFaces.containsKey(ns + i)) continue;
                list.add(netFaces.get(ns + i));
            }
        }
        return list;
    }

    public static boolean ipOk(String ip) {
        return !Strings.isBlank(ip) && !ip.startsWith("127.0") && !ip.startsWith("169.");
    }

    static {
        ntMap.put(NetworkType.LAN, "eth, en");
        ntMap.put(NetworkType.WIFI, "wlan");
        ntMap.put(NetworkType.ThreeG, "ppp");
        ntMap.put(NetworkType.VPN, "tun");
    }
}

