/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.aop.DefaultClassDefiner;
import org.nutz.lang.Lang;
import org.nutz.lang.reflect.ConstructorComparator;
import org.nutz.lang.reflect.FastClass;
import org.nutz.lang.reflect.FastClassAdpter;
import org.nutz.lang.reflect.MethodComparator;
import org.nutz.repo.org.objectweb.asm.ClassWriter;
import org.nutz.repo.org.objectweb.asm.Label;
import org.nutz.repo.org.objectweb.asm.MethodVisitor;
import org.nutz.repo.org.objectweb.asm.Opcodes;
import org.nutz.repo.org.objectweb.asm.Type;

public final class FastClassFactory
implements Opcodes {
    public static Map<String, FastClass> cache = new ConcurrentHashMap<String, FastClass>();
    private static final Object lock = new Object();
    protected static boolean useCache = true;

    public static boolean isUseCache() {
        return useCache;
    }

    public static void setUseCache(boolean useCache) {
        FastClassFactory.useCache = useCache;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static FastClass get(Class<?> klass) {
        String cacheKey = klass.getName() + "_" + klass.getClassLoader();
        FastClass fastClass = cache.get(cacheKey);
        if (fastClass != null) {
            return fastClass;
        }
        Object object = lock;
        synchronized (object) {
            fastClass = cache.get(cacheKey);
            if (fastClass != null) {
                return fastClass;
            }
            try {
                fastClass = FastClassFactory.create(klass);
                if (useCache) {
                    cache.put(cacheKey, fastClass);
                }
                return fastClass;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Fail to create FastClass for " + cacheKey, e);
            }
        }
    }

    public static Object invoke(Object obj, Method method, Object ... args) {
        return FastClassFactory.get(method.getDeclaringClass()).invoke(obj, method, args);
    }

    protected static synchronized FastClass create(Class<?> classZ) {
        String myName = classZ.getName().replace('.', '/');
        if (myName.startsWith("java")) {
            myName = "org/nutz/lang/reflect/" + myName;
        }
        myName = myName + "$$FASTCLASS";
        ClassWriter cw = new ClassWriter(2);
        cw.visit(49, 1, myName, null, "org/nutz/lang/reflect/AbstractFastClass", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Class;[Ljava/lang/reflect/Constructor;[Ljava/lang/reflect/Method;[Ljava/lang/reflect/Field;)V", "(Ljava/lang/Class<*>;[Ljava/lang/reflect/Constructor<*>;[Ljava/lang/reflect/Method;[Ljava/lang/reflect/Field;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(183, "org/nutz/lang/reflect/AbstractFastClass", "<init>", "(Ljava/lang/Class;[Ljava/lang/reflect/Constructor;[Ljava/lang/reflect/Method;[Ljava/lang/reflect/Field;)V");
        mv.visitInsn(177);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
        Method[] methods = classZ.getMethods();
        Arrays.sort(methods, new MethodComparator());
        String[] methodNames = new String[methods.length];
        String[] descs = new String[methods.length];
        int[] nArray = new int[methods.length];
        int[] invokeOps = new int[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
            descs[i] = Type.getMethodDescriptor(methods[i]);
            nArray[i] = methods[i].getModifiers();
            invokeOps[i] = classZ.isInterface() ? 185 : (Modifier.isStatic(methods[i].getModifiers()) ? 184 : 182);
        }
        FastClassAdpter.createInokeMethod(cw.visitMethod(129, "_invoke", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null), methodNames, descs, nArray, invokeOps, classZ.getName().replace('.', '/'));
        Constructor<?>[] constructors = classZ.getConstructors();
        Arrays.sort(constructors, new ConstructorComparator());
        if (constructors.length > 0) {
            String enhancedSuperName = classZ.getName().replace('.', '/');
            FastClassAdpter.createInokeConstructor(cw.visitMethod(132, "_born", "(I[Ljava/lang/Object;)Ljava/lang/Object;", null, null), enhancedSuperName, constructors);
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterTypes().length != 0) continue;
                MethodVisitor mv2 = cw.visitMethod(1, "born", "()Ljava/lang/Object;", null, null);
                mv2.visitCode();
                Label tmp = new Label();
                mv2.visitLabel(tmp);
                mv2.visitLineNumber(1, tmp);
                mv2.visitTypeInsn(187, enhancedSuperName);
                mv2.visitInsn(89);
                mv2.visitMethodInsn(183, enhancedSuperName, "<init>", Type.getConstructorDescriptor(constructor));
                mv2.visitInsn(176);
                mv2.visitMaxs(2, 1);
                mv2.visitEnd();
                break;
            }
        }
        cw.visitSource(classZ.getSimpleName() + ".java", null);
        cw.visitEnd();
        Class<?> xClass = DefaultClassDefiner.defaultOne().define(myName.replace('/', '.'), cw.toByteArray(), classZ.getClassLoader());
        try {
            return (FastClass)xClass.getConstructor(Class.class, Constructor[].class, Method[].class, Field[].class).newInstance(classZ, constructors, methods, null);
        }
        catch (Exception exception) {
            throw Lang.impossible();
        }
    }
}

