/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mapl.impl.convert;

import java.util.ArrayList;
import java.util.List;
import org.nutz.json.Json;
import org.nutz.lang.Streams;
import org.nutz.mapl.MaplConvert;
import org.nutz.mapl.impl.MaplEach;
import org.nutz.mapl.impl.MaplRebuild;

public class FilterConvertImpl
extends MaplEach
implements MaplConvert {
    private List<String> items = new ArrayList<String>();
    private boolean clude = false;
    private MaplRebuild build = new MaplRebuild();

    public FilterConvertImpl(String path) {
        this.items = (List)Json.fromJson(Streams.fileInr(path));
    }

    public FilterConvertImpl(List<String> paths) {
        this.items = paths;
    }

    @Override
    public Object convert(Object obj) {
        this.each(obj);
        return this.build.fetchNewobj();
    }

    @Override
    protected void DLR(String path, Object item) {
        if (this.clude && this.items.contains(path)) {
            this.build.put(path, item, this.arrayIndex);
        }
    }

    @Override
    protected void LRD(String path, Object item) {
        if (this.clude) {
            return;
        }
        int isFilter = 0;
        for (String p : this.items) {
            if (!p.equals(path) && !path.startsWith(p + ".") && !p.startsWith(path + ".") && !path.startsWith(p + "[]") && !p.startsWith(path + "[]")) continue;
            ++isFilter;
        }
        if (isFilter == 0) {
            this.build.put(path, item, this.arrayIndex);
        }
    }

    public void useExcludeModel() {
        this.clude = false;
    }

    public void useIncludeModel() {
        this.clude = true;
    }
}

