/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.img.Images;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.View;

public class RawView
implements View {
    private static final Log log = Logs.get();
    private static final int big4G = Integer.MAX_VALUE;
    public static final boolean DISABLE_RANGE_DOWNLOAD = false;
    protected String contentType;
    protected static final Map<String, String> contentTypeMap = new HashMap<String, String>();

    protected RawView() {
    }

    public RawView(String contentType) {
        if (Strings.isBlank(contentType)) {
            contentType = "text/plain";
        }
        this.contentType = Strings.sNull(contentTypeMap.get(contentType.toLowerCase()), contentType);
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Throwable {
        if (resp.getContentType() == null) {
            if (!Lang.isAndroid && obj != null && obj instanceof BufferedImage && "text/plain".equals(this.contentType)) {
                this.contentType = contentTypeMap.get("png");
            }
            resp.setContentType(this.contentType);
        }
        if (obj == null) {
            return;
        }
        if (!Lang.isAndroid && obj instanceof BufferedImage) {
            ServletOutputStream out = resp.getOutputStream();
            if (this.contentType.contains("png")) {
                ImageIO.write((RenderedImage)((BufferedImage)obj), "png", (OutputStream)out);
            } else if (this.contentType.contains("webp")) {
                ImageIO.write((RenderedImage)((BufferedImage)obj), "webp", (OutputStream)out);
            } else {
                Images.writeJpeg((BufferedImage)obj, out, 0.8f);
            }
            return;
        }
        if (obj instanceof File) {
            File file = (File)obj;
            long fileSz = file.length();
            if (log.isDebugEnabled()) {
                log.debug("File downloading ... " + file.getAbsolutePath());
            }
            if (!file.exists() || file.isDirectory()) {
                log.debug("File downloading ... Not Exist : " + file.getAbsolutePath());
                resp.sendError(404);
                return;
            }
            if (!resp.containsHeader("Content-Disposition")) {
                String filename = URLEncoder.encode(file.getName(), "UTF-8");
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            }
            String rangeStr = req.getHeader("Range");
            ServletOutputStream out = resp.getOutputStream();
            if (fileSz == 0L || rangeStr == null || !rangeStr.startsWith("bytes=") || rangeStr.length() < "bytes=1".length()) {
                resp.setHeader("Content-Length", "" + fileSz);
                Streams.writeAndClose((OutputStream)out, Streams.fileIn(file));
            } else {
                ArrayList<RangeRange> rs = new ArrayList<RangeRange>();
                if (!RawView.parseRange(rangeStr, rs, fileSz)) {
                    resp.setStatus(416);
                    return;
                }
                if (rs.size() != 1) {
                    log.info("multipart/byteranges is NOT support yet");
                    resp.setStatus(416);
                    return;
                }
                long totolSize = 0L;
                for (RangeRange rangeRange : rs) {
                    totolSize += rangeRange.end - rangeRange.start;
                }
                resp.setStatus(206);
                resp.setHeader("Content-Length", "" + totolSize);
                resp.setHeader("Accept-Ranges", "bytes");
                RangeRange rangeRange = (RangeRange)rs.get(0);
                resp.setHeader("Content-Range", String.format("bytes %d-%d/%d", rangeRange.start, rangeRange.end - 1L, fileSz));
                RawView.writeFileRange(file, (OutputStream)out, rangeRange);
            }
        } else if (obj instanceof byte[]) {
            resp.setHeader("Content-Length", "" + ((byte[])obj).length);
            ServletOutputStream out = resp.getOutputStream();
            Streams.writeAndClose((OutputStream)out, (byte[])obj);
        } else if (obj instanceof char[]) {
            PrintWriter writer = resp.getWriter();
            ((Writer)writer).write((char[])obj);
            ((Writer)writer).flush();
        } else if (obj instanceof Reader) {
            Streams.writeAndClose((Writer)resp.getWriter(), (Reader)obj);
        } else if (obj instanceof InputStream) {
            ServletOutputStream out = resp.getOutputStream();
            Streams.writeAndClose((OutputStream)out, (InputStream)obj);
        } else {
            byte[] data = String.valueOf(obj).getBytes("UTF-8");
            resp.setHeader("Content-Length", "" + data.length);
            ServletOutputStream out = resp.getOutputStream();
            Streams.writeAndClose((OutputStream)out, data);
        }
    }

    public static final boolean parseRange(String rangeStr, List<RangeRange> rs, long maxSize) {
        String[] ranges;
        rangeStr = rangeStr.substring("bytes=".length());
        for (String range : ranges = rangeStr.split(",")) {
            if (range == null || Strings.isBlank(range)) {
                log.debug("Bad Range -->    " + rangeStr);
                return false;
            }
            range = range.trim();
            try {
                if (range.startsWith("-")) {
                    long end = Long.parseLong(range);
                    long start = maxSize + end;
                    if (start < 0L) {
                        log.debug("Bad Range -->    " + rangeStr);
                        return false;
                    }
                    rs.add(new RangeRange(start, maxSize));
                    continue;
                }
                if (range.endsWith("-")) {
                    long start = Long.parseLong(range.substring(0, range.length() - 1));
                    if (start < 0L) {
                        log.debug("Bad Range -->    " + rangeStr);
                        return false;
                    }
                    rs.add(new RangeRange(start, maxSize));
                    continue;
                }
                if (range.contains("-")) {
                    long end;
                    String[] tmp = range.split("-");
                    long start = Long.parseLong(tmp[0]);
                    if (start > (end = Long.parseLong(tmp[1]))) {
                        log.debug("Bad Range -->    " + rangeStr);
                        return false;
                    }
                    rs.add(new RangeRange(start, end + 1L));
                    continue;
                }
                long start = Long.parseLong(range);
                rs.add(new RangeRange(start, start + 1L));
            }
            catch (Throwable e) {
                log.debug("Bad Range -->    " + rangeStr, e);
                return false;
            }
        }
        return !rs.isEmpty();
    }

    public static void writeDownloadRange(DataInputStream in, OutputStream out, RangeRange rangeRange) {
        try {
            if (rangeRange.start > 0L) {
                for (long start = rangeRange.start; start > 0L; start -= Integer.MAX_VALUE) {
                    if (start > Integer.MAX_VALUE) {
                        in.skipBytes(Integer.MAX_VALUE);
                        continue;
                    }
                    in.skipBytes((int)start);
                    break;
                }
            }
            byte[] buf = new byte[8192];
            BufferedInputStream bin = new BufferedInputStream(in);
            long pos = rangeRange.start;
            int len = 0;
            while (pos < rangeRange.end && (len = rangeRange.end - pos > 8192L ? bin.read(buf) : bin.read(buf, 0, (int)(rangeRange.end - pos))) != -1) {
                if (len <= 0) continue;
                out.write(buf, 0, len);
                pos += (long)len;
            }
            out.flush();
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void writeFileRange(File file, OutputStream out, RangeRange rangeRange) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            DataInputStream in = new DataInputStream(fin);
            RawView.writeDownloadRange(in, out, rangeRange);
        }
        catch (Throwable e) {
            try {
                throw Lang.wrapThrow(e);
            }
            catch (Throwable throwable) {
                Streams.safeClose(fin);
                throw throwable;
            }
        }
        Streams.safeClose(fin);
    }

    static {
        contentTypeMap.put("xml", "application/xml");
        contentTypeMap.put("html", "text/html");
        contentTypeMap.put("htm", "text/html");
        contentTypeMap.put("stream", "application/octet-stream");
        contentTypeMap.put("js", "application/javascript");
        contentTypeMap.put("json", "application/json");
        contentTypeMap.put("jpg", "image/jpeg");
        contentTypeMap.put("jpeg", "image/jpeg");
        contentTypeMap.put("png", "image/png");
        contentTypeMap.put("webp", "image/webp");
    }

    public static class RangeRange {
        long start;
        long end = -1L;

        public RangeRange(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

