/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.NutRuntimeException;
import org.nutz.lang.util.Disks;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;
import org.nutz.resource.impl.FileResource;
import org.nutz.resource.impl.ResourceLocation;

public class FileSystemResourceLocation
extends ResourceLocation {
    private File root;

    @Override
    public String id() {
        return this.root.getAbsolutePath();
    }

    @Override
    public void scan(String base, Pattern pattern, List<NutResource> list) {
        File baseFile = new File(this.root.getAbsolutePath() + "/" + base);
        if (baseFile.isFile()) {
            list.add(new FileResource(baseFile));
            return;
        }
        Disks.visitFile(baseFile, new Scans.ResourceFileVisitor(list, base), new Scans.ResourceFileFilter(pattern));
    }

    public String toString() {
        return "Dir[path=" + this.root + "]";
    }

    public FileSystemResourceLocation(File root) throws IOException {
        if (root == null) {
            throw new NutRuntimeException("FileSystemResourceLocation root can't be NULL");
        }
        this.root = root.getAbsoluteFile().getCanonicalFile();
    }
}

