/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.segment.Segment;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Proton;

public class TableName {
    private static final Log log = Logs.get();
    private static final ThreadLocal<Object> object = new ThreadLocal();

    public static void run(Object refer, Runnable atom) {
        if (null != atom) {
            if (log.isTraceEnabled()) {
                log.tracef("TableName.run: [%s]->[%s]", object, object.get());
            }
            Object old = TableName.get();
            TableName.set(refer);
            try {
                atom.run();
            }
            catch (Exception e) {
                try {
                    throw Lang.wrapThrow(e);
                }
                catch (Throwable throwable) {
                    TableName.set(old);
                    if (log.isTraceEnabled()) {
                        log.tracef("TableName.finally: [%s]->[%s]", object, object.get());
                    }
                    throw throwable;
                }
            }
            TableName.set(old);
            if (log.isTraceEnabled()) {
                log.tracef("TableName.finally: [%s]->[%s]", object, object.get());
            }
        }
    }

    public static <T> T run(Object refer, Proton<T> proton) {
        T t;
        if (log.isTraceEnabled()) {
            log.tracef("TableName.run: [%s]->[%s]", object, object.get());
        }
        Object old = TableName.get();
        TableName.set(refer);
        try {
            proton.run();
            t = proton.get();
        }
        catch (Exception e) {
            try {
                throw Lang.wrapThrow(e);
            }
            catch (Throwable throwable) {
                TableName.set(old);
                if (log.isTraceEnabled()) {
                    log.tracef("TableName.finally: [%s]->[%s]", object, object.get());
                }
                throw throwable;
            }
        }
        TableName.set(old);
        if (log.isTraceEnabled()) {
            log.tracef("TableName.finally: [%s]->[%s]", object, object.get());
        }
        return t;
    }

    public static Object get() {
        return object.get();
    }

    public static Object set(Object obj) {
        Object re = TableName.get();
        object.set(obj);
        return re;
    }

    public static void clear() {
        TableName.set(null);
    }

    public static String render(Segment tableName) {
        Object obj = TableName.get();
        if (null == obj || !tableName.hasKey()) {
            return tableName.toString();
        }
        Context context = Lang.context();
        if (TableName.isPrimitive(obj)) {
            for (String key : tableName.keys()) {
                context.set(key, obj);
            }
        } else if (obj instanceof Context) {
            for (String key : tableName.keys()) {
                context.set(key, ((Context)obj).get(key));
            }
        } else if (obj instanceof Map) {
            for (String key : tableName.keys()) {
                context.set(key, ((Map)obj).get(key));
            }
        } else {
            Mirror<Object> mirror = Mirror.me(obj);
            for (String key : tableName.keys()) {
                context.set(key, mirror.getValue(obj, key));
            }
        }
        return tableName.render(context).toString();
    }

    public static boolean isPrimitive(Object obj) {
        return obj instanceof CharSequence || obj instanceof Number || obj.getClass().isPrimitive();
    }
}

