/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DaoInterceptor;
import org.nutz.dao.DaoInterceptorChain;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.SqlManager;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.AnnotationEntityMaker;
import org.nutz.dao.impl.interceptor.DaoLogInterceptor;
import org.nutz.dao.impl.interceptor.DaoTimeInterceptor;
import org.nutz.dao.impl.sql.NutPojoMaker;
import org.nutz.dao.impl.sql.run.NutDaoExecutor;
import org.nutz.dao.impl.sql.run.NutDaoRunner;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.PojoMaker;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlContext;
import org.nutz.dao.util.Daos;
import org.nutz.lang.Configurable;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DaoSupport
implements Configurable {
    private static final Log log = Logs.get();
    protected DaoRunner runner = new NutDaoRunner();
    protected DaoExecutor executor = new NutDaoExecutor();
    protected DataSource dataSource;
    protected JdbcExpert expert;
    protected PojoMaker pojoMaker;
    protected EntityHolder holder;
    protected DatabaseMeta meta;
    protected SqlManager sqlManager;
    protected int autoTransLevel = 2;
    protected List<DaoInterceptor> _interceptors;

    public DaoSupport() {
        this.setInterceptors(Lang.list("log"));
    }

    public SqlManager sqls() {
        return this.sqlManager;
    }

    public DatabaseMeta meta() {
        return this.meta;
    }

    public void setSqlManager(SqlManager sqls) {
        this.sqlManager = sqls;
        if (sqls != null) {
            int count = sqls.count();
            log.debug("SqlManager Sql count=" + count);
        }
    }

    public void setRunner(DaoRunner runner) {
        this.runner = runner;
        if (runner instanceof NutDaoRunner) {
            ((NutDaoRunner)runner).setMeta(this.meta);
        }
    }

    public void setExecutor(DaoExecutor executor) {
        this.executor = executor;
        if (executor instanceof NutDaoExecutor) {
            ((NutDaoExecutor)executor).setMeta(this.meta);
            ((NutDaoExecutor)executor).setExpert(this.expert);
        }
    }

    public void setPojoMaker(PojoMaker pojoMaker) {
        this.pojoMaker = pojoMaker;
    }

    public JdbcExpert getJdbcExpert() {
        return this.expert;
    }

    public void setDataSource(DataSource ds) {
        this.setDataSource(ds, false);
    }

    public void setDataSource(DataSource ds, boolean isLazy) {
        if (null != this.dataSource && log.isWarnEnabled()) {
            log.warn("Replaced a running dataSource!");
        }
        this.dataSource = ds;
        if (this.expert == null) {
            this.expert = Jdbcs.getExpert(ds);
        }
        log.debug("select expert : " + this.expert.getClass().getName());
        this.pojoMaker = new NutPojoMaker(this.expert);
        this.meta = new DatabaseMeta();
        final HashSet<String> keywords = new HashSet<String>(Daos.sql2003Keywords());
        this.run(new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                try {
                    String tmp;
                    DatabaseMetaData dmd = conn.getMetaData();
                    DaoSupport.this.meta.setProductName(dmd.getDatabaseProductName());
                    DaoSupport.this.meta.setVersion(dmd.getDatabaseProductVersion());
                    log.debug("JDBC Driver --> " + dmd.getDriverVersion());
                    log.debug("JDBC Name   --> " + dmd.getDriverName());
                    if (!Strings.isBlank(dmd.getURL())) {
                        log.debug("JDBC URL    --> " + dmd.getURL());
                    }
                    if (dmd.getDriverName().contains("mariadb") || dmd.getDriverName().contains("sqlite")) {
                        log.warn("Auto-select fetch size to Integer.MIN_VALUE, enable for ResultSet Streaming");
                        SqlContext.DEFAULT_FETCH_SIZE = Integer.MIN_VALUE;
                    }
                    if ((tmp = dmd.getSQLKeywords()) != null) {
                        for (String keyword : tmp.split(",")) {
                            keywords.add(keyword.toUpperCase());
                        }
                    }
                    DaoSupport.this.expert.checkDataSource(conn);
                }
                catch (Exception e) {
                    log.info("something wrong when checking DataSource", e);
                }
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Database info --> " + this.meta);
        }
        this.expert.setKeywords(keywords);
        if (!isLazy) {
            this.holder = new EntityHolder(this.expert, this.dataSource);
            this.holder.maker = this.createEntityMaker();
        }
        this.setRunner(this.runner);
        this.setExecutor(this.executor);
    }

    public void execute(Sql ... sqls) {
        for (Sql sql : sqls) {
            this.expert.formatQuery(sql);
        }
        this._exec(sqls);
    }

    public void run(ConnCallback callback) {
        this.runner.run(this.dataSource, callback);
    }

    protected int _exec(DaoStatement ... sts) {
        if (sts != null) {
            for (DaoStatement ds : sts) {
                ds.setExpert(this.expert);
            }
        }
        DaoInterceptorChain callback = new DaoInterceptorChain(sts);
        callback.setExecutor(this.executor);
        callback.setAutoTransLevel(this.autoTransLevel);
        callback.setInterceptors(Collections.unmodifiableList(this._interceptors));
        this.run(callback);
        return callback.getUpdateCount();
    }

    protected EntityMaker createEntityMaker() {
        return new AnnotationEntityMaker(this.dataSource, this.expert, this.holder);
    }

    public PojoMaker pojoMaker() {
        return this.pojoMaker;
    }

    public void setAutoTransLevel(int autoTransLevel) {
        this.autoTransLevel = autoTransLevel;
    }

    public void setInterceptors(List<Object> interceptors) {
        LinkedList<DaoInterceptor> list = new LinkedList<DaoInterceptor>();
        for (Object it : interceptors) {
            DaoInterceptor d = this.makeInterceptor(it);
            if (d == null) continue;
            list.add(d);
        }
        this._interceptors = list;
    }

    public void addInterceptor(Object it) {
        DaoInterceptor d = this.makeInterceptor(it);
        if (d != null) {
            LinkedList<DaoInterceptor> list = new LinkedList<DaoInterceptor>(this._interceptors);
            list.add(d);
            this._interceptors = list;
        }
    }

    public DaoInterceptor makeInterceptor(Object it) {
        DaoInterceptor re = this._makeInterceptor(it);
        if (re != null && re instanceof DaoExecutor) {
            ((NutDaoExecutor)((Object)re)).setMeta(this.meta);
        }
        return re;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DaoInterceptor _makeInterceptor(Object it) {
        if (it == null) {
            return null;
        }
        if (it instanceof String) {
            String itName = it.toString().trim();
            if ("log".equals(itName)) {
                return new DaoLogInterceptor();
            }
            if ("time".equals(itName)) {
                return new DaoTimeInterceptor();
            }
            if (itName.contains(".")) {
                Class<?> klass = Lang.loadClassQuite(itName);
                if (klass != null) return (DaoInterceptor)((Object)Mirror.me(klass).born(new Object[0]));
                log.warn("no such interceptor name=" + itName);
                return null;
            } else {
                log.info("unkown interceptor name=" + itName);
            }
            return null;
        } else {
            if (it instanceof DaoInterceptor) {
                return (DaoInterceptor)it;
            }
            log.info("unkown interceptor -> " + it);
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setupProperties(NutMap conf) {
        if (this.expert instanceof Configurable) {
            ((Configurable)((Object)this.expert)).setupProperties(conf);
        }
        if (this.executor instanceof Configurable) {
            ((Configurable)((Object)this.executor)).setupProperties(conf);
        }
        if (this.runner instanceof Configurable) {
            ((Configurable)((Object)this.runner)).setupProperties(conf);
        }
    }
}

