/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import java.util.ArrayList;
import java.util.List;
import org.nutz.dao.TableName;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityField;
import org.nutz.dao.entity.EntityIndex;
import org.nutz.lang.segment.CharSegment;

public class NutEntityIndex
implements EntityIndex {
    private boolean unique;
    private String name;
    private List<EntityField> fields = new ArrayList<EntityField>(3);

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(Entity<?> en) {
        if (this.name.contains("$")) {
            return TableName.render(new CharSegment(this.name));
        }
        if (this.name.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isUnique() ? "UX_" : "IX_");
            sb.append(en.getTableName());
            for (EntityField field : this.getFields()) {
                sb.append("_").append(field.getName());
            }
            return sb.toString();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addField(EntityField field) {
        this.fields.add(field);
    }

    @Override
    public List<EntityField> getFields() {
        return this.fields;
    }

    public void setFields(List<EntityField> fields) {
        this.fields = fields;
    }
}

