/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.Record;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.lang.Lang;

public class SqlTemplate {
    private Dao dao;

    public SqlTemplate() {
    }

    public SqlTemplate(Dao dao) {
        this.setDao(dao);
    }

    public void setDao(Dao dao) {
        this.dao = dao;
    }

    public Dao dao() {
        return this.dao;
    }

    public int update(String sql, Map<String, Object> params) {
        return this.update(sql, null, params);
    }

    public int update(String sql, Map<String, Object> vars, Map<String, Object> params) {
        Sql sqlObj = this.createSqlObj(sql, params);
        this.execute(sqlObj, vars, params);
        return sqlObj.getUpdateCount();
    }

    public int batchUpdate(String sql, List<Map<String, Object>> batchValues) {
        return this.batchUpdate(sql, null, batchValues);
    }

    public int batchUpdate(String sql, Map<String, Object> vars, List<Map<String, Object>> batchValues) {
        Sql sqlObj = null;
        if (batchValues != null && batchValues.size() > 0) {
            sqlObj = this.createSqlObj(sql, batchValues.get(0));
            for (Map<String, Object> params : batchValues) {
                Map<String, Object> newParams = this.paramProcess(params);
                sqlObj.params().putAll(newParams);
                sqlObj.addBatch();
            }
            this.dao.execute(sqlObj);
        } else {
            sqlObj = this.createSqlObj(sql, null);
            this.execute(sqlObj, vars, null);
        }
        return sqlObj.getUpdateCount();
    }

    public int queryForInt(String sql, Map<String, Object> params) {
        return this.queryForInt(sql, null, params);
    }

    public int queryForInt(String sql, Map<String, Object> vars, Map<String, Object> params) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(Sqls.callback.integer());
        this.execute(sqlObj, vars, params);
        return sqlObj.getInt();
    }

    public long queryForLong(String sql, Map<String, Object> params) {
        return this.queryForLong(sql, null, params);
    }

    public long queryForLong(String sql, Map<String, Object> vars, Map<String, Object> params) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(Sqls.callback.longValue());
        this.execute(sqlObj, vars, params);
        Long result = sqlObj.getObject(Long.class);
        return result == null ? 0L : result;
    }

    public <T> T queryForObject(String sql, Map<String, Object> params, Class<T> classOfT) {
        return this.queryForObject(sql, null, params, classOfT);
    }

    public <T> T queryForObject(String sql, Map<String, Object> vars, Map<String, Object> params, Class<T> classOfT) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(new SqlCallback(){

            @Override
            public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                if (null != rs && rs.next()) {
                    return rs.getObject(1);
                }
                return null;
            }
        });
        this.execute(sqlObj, vars, params);
        return sqlObj.getObject(classOfT);
    }

    public <T> T queryForObject(String sql, Map<String, Object> params, Entity<T> entity) {
        return this.queryForObject(sql, null, params, entity);
    }

    public <T> T queryForObject(String sql, Map<String, Object> vars, Map<String, Object> params, Entity<T> entity) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(Sqls.callback.entity());
        sqlObj.setEntity((Entity)entity);
        this.execute(sqlObj, vars, params);
        return sqlObj.getObject(entity.getType());
    }

    public Record queryForRecord(String sql, Map<String, Object> params) {
        return this.queryForRecord(sql, null, params);
    }

    public Record queryForRecord(String sql, Map<String, Object> vars, Map<String, Object> params) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(Sqls.callback.record());
        this.execute(sqlObj, vars, params);
        return sqlObj.getObject(Record.class);
    }

    public <T> List<T> query(String sql, Map<String, Object> params, Entity<T> entity) {
        return this.query(sql, null, params, entity);
    }

    public <T> List<T> query(String sql, Map<String, Object> params, Class<T> classOfT) {
        return this.query(sql, null, params, this.dao.getEntity(classOfT));
    }

    public <T> List<T> query(String sql, Map<String, Object> vars, Map<String, Object> params, Entity<T> entity) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(Sqls.callback.entities());
        sqlObj.setEntity((Entity)entity);
        this.execute(sqlObj, vars, params);
        return sqlObj.getList(entity.getType());
    }

    public <T> List<T> queryForList(String sql, Map<String, Object> vars, Map<String, Object> params, final Class<T> classOfT) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(new SqlCallback(){

            @Override
            public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                ArrayList list = new ArrayList();
                while (rs.next()) {
                    Object result = Castors.me().castTo(rs.getObject(1), classOfT);
                    list.add(result);
                }
                return list;
            }
        });
        this.execute(sqlObj, vars, params);
        return sqlObj.getList(classOfT);
    }

    public List<Record> queryRecords(String sql, Map<String, Object> vars, Map<String, Object> params) {
        Sql sqlObj = this.createSqlObj(sql, params);
        sqlObj.setCallback(Sqls.callback.records());
        this.execute(sqlObj, vars, params);
        return sqlObj.getList(Record.class);
    }

    private void execute(Sql sqlObj, Map<String, Object> vars, Map<String, Object> params) {
        if (vars != null) {
            sqlObj.vars().putAll(vars);
        }
        if (params != null) {
            Map<String, Object> newParams = this.paramProcess(params);
            sqlObj.params().putAll(newParams);
        }
        this.dao().execute(sqlObj);
    }

    private Sql createSqlObj(String sql, Map<String, Object> params) {
        if (params == null) {
            return Sqls.create(sql);
        }
        String newSql = this.sqlProcess(sql, params);
        return Sqls.create(newSql);
    }

    private String sqlProcess(String originSql, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return originSql;
        }
        String newSql = originSql;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String paramName = entry.getKey();
            Object paramObj = entry.getValue();
            if (paramObj == null) continue;
            if (paramObj.getClass().isArray()) {
                String inSqlExp = SqlTemplate.inSqlProcess(paramName, paramObj);
                newSql = newSql.replaceAll("@" + paramName, inSqlExp);
            }
            if (!(paramObj instanceof Collection)) continue;
            Collection collection = (Collection)paramObj;
            E[] paramVals = Lang.collection2array(collection);
            String inSqlExp = SqlTemplate.inSqlProcess(paramName, paramVals);
            newSql = newSql.replaceAll("@" + paramName, inSqlExp);
        }
        return newSql;
    }

    private Map<String, Object> paramProcess(Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        HashMap<String, Object> newParams = new HashMap<String, Object>(params);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String paramName = entry.getKey();
            Object paramObj = entry.getValue();
            if (paramObj == null) continue;
            if (paramObj.getClass().isArray()) {
                SqlTemplate.inParamProcess(paramName, paramObj, newParams);
                newParams.remove(paramName);
            }
            if (!(paramObj instanceof Collection)) continue;
            Collection collection = (Collection)paramObj;
            E[] paramVals = Lang.collection2array(collection);
            SqlTemplate.inParamProcess(paramName, paramVals, newParams);
            newParams.remove(paramName);
        }
        return newParams;
    }

    private static String inSqlProcess(String paramName, Object paramObj) {
        int len = Array.getLength(paramObj);
        StringBuilder inSqlExp = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            inSqlExp.append("@").append(paramName).append(i).append(",");
        }
        inSqlExp.deleteCharAt(inSqlExp.length() - 1);
        return inSqlExp.toString();
    }

    private static void inParamProcess(String paramName, Object paramObj, Map<String, Object> newParams) {
        int len = Array.getLength(paramObj);
        for (int i = 0; i < len; ++i) {
            String inParamName = paramName + i;
            newParams.put(inParamName, Array.get(paramObj, i));
        }
    }
}

