/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.pojo;

import org.nutz.dao.Chain;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.Lang;

public class UpdateFieldsByChainPItem
extends AbstractPItem {
    private static final long serialVersionUID = 1L;
    private Chain chain;

    public UpdateFieldsByChainPItem(Chain chain) {
        this.chain = chain;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (this.chain.size() > 0) {
            sb.append(" SET ");
            for (Chain c = this.chain.head(); c != null; c = c.next()) {
                sb.append(this._fmtcolnm(en, c.name())).append('=');
                if (c.special()) {
                    String str;
                    Chain head = c;
                    if (head.value() != null && head.value() instanceof String && (str = (String)head.value()).length() > 0) {
                        switch (str.charAt(0)) {
                            case '%': 
                            case '&': 
                            case '*': 
                            case '+': 
                            case '-': 
                            case '/': 
                            case '^': 
                            case '|': {
                                sb.append(this._fmtcolnm(en, c.name()));
                                break;
                            }
                        }
                    }
                    sb.append(head.value());
                } else {
                    sb.append("?");
                }
                sb.append(',');
            }
        } else {
            throw Lang.makeThrow("Entity chain for UPDATE '%s'", en.getType().getName());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(' ');
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        for (Chain c = this.chain.head(); c != null; c = c.next()) {
            if (c.special()) continue;
            MappingField mf = en.getField(c.name());
            if (c.adaptor() == null) {
                adaptors[off++] = null == mf ? Jdbcs.getAdaptorBy(c.value()) : mf.getAdaptor();
                continue;
            }
            adaptors[off++] = c.adaptor();
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        for (Chain c = this.chain.head(); c != null; c = c.next()) {
            if (c.special()) continue;
            params[off++] = c.value();
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        int count = 0;
        for (Chain c = this.chain.head(); c != null; c = c.next()) {
            if (c.special()) continue;
            ++count;
        }
        return count;
    }
}

