/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import org.nutz.dao.entity.Entity;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.util.cri.AbstractSqlExpression;
import org.nutz.dao.util.lambda.PFun;

public class NameRange
extends AbstractSqlExpression {
    private static final long serialVersionUID = 1L;
    private String[] names;

    NameRange(String name, String ... names) {
        super(name);
        this.names = names;
        this.not = false;
    }

    <T> NameRange(PFun<T, ?> name, String ... names) {
        super(name);
        this.names = names;
        this.not = false;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (this.names.length > 0) {
            sb.append(this._fmtcol(en));
            if (this.not) {
                sb.append(" NOT");
            }
            sb.append(" IN (");
            for (int i = 0; i < this.names.length; ++i) {
                sb.append("?,");
            }
            sb.setCharAt(sb.length() - 1, ')');
        }
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        for (int i = 0; i < this.names.length; ++i) {
            adaptors[off++] = Jdbcs.Adaptor.asString;
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        for (String name : this.names) {
            params[off++] = name;
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return this.names.length;
    }
}

