/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.handler;

import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.nutz.castor.Castors;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.JsonTypeHandler;
import org.nutz.lang.Mirror;

public class JsonLocalDateLikeHandler
extends JsonTypeHandler {
    @Override
    public boolean supportFromJson(Mirror<?> mirror, Object obj) {
        return mirror.isLocalDateTimeLike();
    }

    @Override
    public boolean supportToJson(Mirror<?> mirror, Object obj, JsonFormat jf) {
        return mirror.isLocalDateTimeLike();
    }

    @Override
    public void toJson(Mirror<?> mirror, Object currentObj, JsonRender r, JsonFormat jf) throws IOException {
        String df = jf.getDateFormatRaw();
        if (mirror.getType().equals(LocalDate.class)) {
            df = "yyyy-MM-dd";
        }
        if (df == null) {
            df = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        Locale locale = null;
        String tmp = jf.getLocale();
        locale = tmp != null ? Locale.forLanguageTag(tmp) : Locale.getDefault();
        r.string2Json(DateTimeFormatter.ofPattern(df, locale).withZone(ZoneId.systemDefault()).format((TemporalAccessor)currentObj));
    }

    @Override
    public Object fromJson(Object obj, Mirror<?> mirror) throws Exception {
        return Castors.me().castTo(obj, mirror.getType());
    }
}

