/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.impl;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.JsonTypeHandler;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.json.impl.JsonPair;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public class JsonRenderImpl
implements JsonRender {
    private static String NL = "\n";
    private JsonFormat format;
    private Writer writer;
    private Set<Object> memo = new HashSet<Object>();
    private boolean compact;
    private int indent;
    private static final Pattern p = Pattern.compile("^[a-z_A-Z$]+[a-zA-Z_0-9$]*$");

    public JsonFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(JsonFormat format) {
        this.format = format;
        this.compact = format.isCompact();
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void render(Object obj) throws IOException {
        if (null == obj) {
            this.appendNull();
            return;
        }
        Mirror<Object> mirror = Mirror.me(obj);
        for (JsonTypeHandler handler : Json.getTypeHandlers()) {
            if (!handler.supportToJson(mirror, obj, this.format)) continue;
            if (handler.shallCheckMemo()) {
                if (this.memo.contains(obj)) {
                    this.writer.write("null");
                    return;
                }
                this.memo.add(obj);
                handler.toJson(mirror, obj, this, this.format);
                this.memo.remove(obj);
            } else {
                handler.toJson(mirror, obj, this, this.format);
            }
            return;
        }
        this.string2Json(String.valueOf(obj));
    }

    public JsonRenderImpl() {
    }

    public JsonRenderImpl(Writer writer, JsonFormat format) {
        this.writer = writer;
        this.setFormat(format);
    }

    @Override
    public void appendName(String name) throws IOException {
        if (this.format.isQuoteName() || !p.matcher(name).find()) {
            this.string2Json(name);
        } else {
            this.writer.append(name);
        }
    }

    @Override
    public void appendPairBegin() throws IOException {
        if (!this.compact) {
            this.writer.append(NL);
            this.doIntent();
        }
    }

    @Override
    public void appendPairSep() throws IOException {
        this.writer.append(!this.compact ? ": " : ":");
    }

    @Override
    public void appendPair(boolean needPairEnd, String name, Object value) throws IOException {
        this.appendPairBegin();
        this.appendName(name);
        this.appendPairSep();
        this.render(value);
        if (needPairEnd) {
            this.appendPairEnd();
        }
    }

    @Override
    public boolean isIgnore(String name, Object value) {
        if (null == value && this.format.isIgnoreNull()) {
            return true;
        }
        return this.format.ignore(name);
    }

    @Override
    public void appendPairEnd() throws IOException {
        this.writer.append(',');
    }

    @Override
    public void appendBraceBegin() throws IOException {
        this.writer.append('{');
    }

    @Override
    public void appendBraceEnd() throws IOException {
        if (!this.compact) {
            this.writer.append(NL);
            this.doIntent();
        }
        this.writer.append('}');
    }

    @Override
    public void map2Json(Map map) throws IOException {
        if (null == map) {
            return;
        }
        this.appendBraceBegin();
        this.increaseFormatIndent();
        ArrayList<JsonPair> list = new ArrayList<JsonPair>(map.size());
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            Object value;
            String name = null == entry.getKey() ? "null" : entry.getKey().toString();
            if (this.isIgnore(name, value = entry.getValue())) continue;
            list.add(new JsonPair(name, value));
        }
        this.writeItem(list);
    }

    @Override
    public void writeItem(List<JsonPair> list) throws IOException {
        Iterator<JsonPair> it = list.iterator();
        while (it.hasNext()) {
            JsonPair p = it.next();
            this.appendPair(it.hasNext(), p.name, p.value);
        }
        this.decreaseFormatIndent();
        this.appendBraceEnd();
    }

    @Override
    public void decreaseFormatIndent() {
        if (!this.compact) {
            --this.indent;
        }
    }

    @Override
    public void increaseFormatIndent() {
        if (!this.compact) {
            ++this.indent;
        }
    }

    @Override
    public void string2Json(String s) throws IOException {
        if (null == s) {
            this.appendNull();
        } else {
            char[] cs = s.toCharArray();
            this.writer.append(this.format.getSeparator());
            block9: for (char c : cs) {
                switch (c) {
                    case '\"': {
                        this.writer.append("\\\"");
                        continue block9;
                    }
                    case '\n': {
                        this.writer.append("\\n");
                        continue block9;
                    }
                    case '\t': 
                    case '\u000b': {
                        this.writer.append("\\t");
                        continue block9;
                    }
                    case '\r': {
                        this.writer.append("\\r");
                        continue block9;
                    }
                    case '\f': {
                        this.writer.append("\\f");
                        continue block9;
                    }
                    case '\b': {
                        this.writer.append("\\b");
                        continue block9;
                    }
                    case '\\': {
                        this.writer.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= '\u0100' && this.format.isAutoUnicode()) {
                            this.writer.append("\\u");
                            String u = Strings.fillHex(c, 4);
                            if (this.format.isUnicodeLower()) {
                                this.writer.write(u.toLowerCase());
                                continue block9;
                            }
                            this.writer.write(u.toUpperCase());
                            continue block9;
                        }
                        if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                            this.writer.write("\\u");
                            String hhhh = Integer.toHexString(c);
                            this.writer.write("0000", 0, 4 - hhhh.length());
                            this.writer.write(hhhh);
                            continue block9;
                        }
                        this.writer.append(c);
                    }
                }
            }
            this.writer.append(this.format.getSeparator());
        }
    }

    @Override
    public String value2string(JsonEntityField jef, Object value) {
        Format df = jef.getDataFormat();
        if (df == null) {
            Mirror<Object> mirror = Mirror.me(value);
            if (value instanceof Date) {
                df = this.format.getDateFormat();
            } else if (mirror.isNumber()) {
                df = this.format.getNumberFormat();
            }
        }
        if (df != null) {
            if (df instanceof DateFormat) {
                return this.doDateFormat((Date)value, (DateFormat)df);
            }
            return df.format(value);
        }
        return value.toString();
    }

    protected void doIntent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(this.format.getIndentBy());
        }
    }

    protected void appendNull() throws IOException {
        if (this.format.isNullAsEmtry()) {
            this.writer.write("\"\"");
        } else {
            this.writer.write("null");
        }
    }

    protected String doDateFormat(Date date, DateFormat df) {
        if (df == null) {
            df = this.format.getDateFormat();
        }
        if (df != null) {
            if (this.format.getTimeZone() != null) {
                df.setTimeZone(this.format.getTimeZone());
            }
            return df.format(date);
        }
        return null;
    }

    @Override
    public void writeRaw(String raw) throws IOException {
        this.writer.write(raw);
    }

    @Override
    public boolean memoContains(Object obj) {
        return this.memo.contains(obj);
    }
}

