/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nutz.lang.Encoding;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.ClassTools;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.Regex;
import org.nutz.log.Logs;

public class Files {
    public static String read(String path) {
        File f = Files.findFile(path);
        if (null == f) {
            throw Lang.makeThrow("Can not find file '%s'", path);
        }
        return Files.read(f);
    }

    public static String read(File f) {
        return Lang.readAll(Streams.fileInr(f));
    }

    public static byte[] readBytes(String path) {
        File f = Files.findFile(path);
        if (null == f) {
            throw Lang.makeThrow("Can not find file '%s'", path);
        }
        return Files.readBytes(f);
    }

    public static byte[] readBytes(File f) {
        return Streams.readBytesAndClose(Streams.buff(Streams.fileIn(f)));
    }

    public static void write(String path, Object obj) {
        if (null == path || null == obj) {
            return;
        }
        try {
            Files.write(Files.createFileIfNoExists(path), obj);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void write(File f, Object obj) {
        if (null == f || null == obj) {
            return;
        }
        if (f.isDirectory()) {
            throw Lang.makeThrow("Directory '%s' can not be write as File", f);
        }
        try {
            if (!f.exists()) {
                Files.createNewFile(f);
            }
            if (obj instanceof InputStream) {
                Streams.writeAndClose(Streams.fileOut(f), (InputStream)obj);
            } else if (obj instanceof byte[]) {
                Streams.writeAndClose(Streams.fileOut(f), (byte[])obj);
            } else if (obj instanceof Reader) {
                Streams.writeAndClose(Streams.fileOutw(f), (Reader)obj);
            } else {
                Streams.writeAndClose(Streams.fileOutw(f), obj.toString());
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void appendWrite(File f, Object obj) {
        if (null == f || null == obj) {
            return;
        }
        if (f.isDirectory()) {
            throw Lang.makeThrow("Directory '%s' can not be write as File", f);
        }
        try {
            if (!f.exists()) {
                Files.createNewFile(f);
            }
            if (obj instanceof InputStream) {
                throw Lang.noImplement();
            }
            if (obj instanceof byte[]) {
                throw Lang.noImplement();
            }
            if (obj instanceof Reader) {
                throw Lang.noImplement();
            }
            Streams.appendWriteAndClose(f, obj.toString());
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static File renameSuffix(File f, String suffix) {
        if (null == f || null == suffix || suffix.length() == 0) {
            return f;
        }
        return new File(Files.renameSuffix(f.getAbsolutePath(), suffix));
    }

    public static String renameSuffix(String path, String suffix) {
        int pos = path.length();
        --pos;
        while (pos > 0 && path.charAt(pos) != '.') {
            if (path.charAt(pos) == '/' || path.charAt(pos) == '\\') {
                pos = -1;
                break;
            }
            --pos;
        }
        if (0 >= pos) {
            return path + suffix;
        }
        return path.substring(0, pos) + suffix;
    }

    public static String getMajorName(String path) {
        int len = path.length();
        int l = 0;
        int r = len;
        for (int i = r - 1; i > 0; --i) {
            if (r == len && path.charAt(i) == '.') {
                r = i;
            }
            if (path.charAt(i) != '/' && path.charAt(i) != '\\') continue;
            l = i + 1;
            break;
        }
        return path.substring(l, r);
    }

    public static String getMajorName(File f) {
        return Files.getMajorName(f.getAbsolutePath());
    }

    public static String getSuffixName(File f) {
        if (null == f) {
            return null;
        }
        return Files.getSuffixName(f.getAbsolutePath());
    }

    public static String getSuffixName(String path) {
        if (null == path) {
            return null;
        }
        path = path.replace('\\', '/');
        int p0 = path.lastIndexOf(46);
        int p1 = path.lastIndexOf(47);
        if (-1 == p0 || p0 < p1) {
            return "";
        }
        return path.substring(p0 + 1);
    }

    public static String getSuffix(File f) {
        if (null == f) {
            return null;
        }
        return Files.getSuffix(f.getAbsolutePath());
    }

    public static String getSuffix(String path) {
        if (null == path) {
            return null;
        }
        path = path.replace('\\', '/');
        int p0 = path.lastIndexOf(46);
        int p1 = path.lastIndexOf(47);
        if (-1 == p0 || p0 < p1) {
            return "";
        }
        return path.substring(p0);
    }

    public static ZipEntry[] findEntryInZip(ZipFile zip, String regex) {
        LinkedList<ZipEntry> list = new LinkedList<ZipEntry>();
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (null != regex && !Regex.match(regex, ze.getName())) continue;
            list.add(ze);
        }
        return list.toArray(new ZipEntry[list.size()]);
    }

    public static File createFileIfNoExists(String path) throws IOException {
        File f;
        String thePath = Disks.absolute(path);
        if (null == thePath) {
            thePath = Disks.normalize(path);
        }
        if (!(f = new File(thePath)).exists()) {
            Files.createNewFile(f);
        }
        if (!f.isFile()) {
            throw Lang.makeThrow("'%s' should be a file!", path);
        }
        return f;
    }

    public static File createFileIfNoExists2(String path) {
        try {
            return Files.createFileIfNoExists(path);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static File createFileIfNoExists(File f) {
        if (null == f) {
            return f;
        }
        if (!f.exists()) {
            try {
                Files.createNewFile(f);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        if (!f.isFile()) {
            throw Lang.makeThrow("'%s' should be a file!", f);
        }
        return f;
    }

    public static File createDirIfNoExists(String path) {
        boolean flag;
        File f;
        String thePath = Disks.absolute(path);
        if (null == thePath) {
            thePath = Disks.normalize(path);
        }
        if (!(f = new File(thePath)).exists() && !(flag = Files.makeDir(f))) {
            Logs.get().warnf("create filepool dir(%s) fail!!", f.getPath());
        }
        if (!f.isDirectory()) {
            throw Lang.makeThrow("'%s' should be a directory or don't have permission to create it!", path);
        }
        return f;
    }

    public static File createDirIfNoExists(File d) {
        if (null == d) {
            return d;
        }
        if (!d.exists() && !Files.makeDir(d)) {
            throw Lang.makeThrow("fail to create '%s', permission deny?", d.getAbsolutePath());
        }
        if (!d.isDirectory()) {
            throw Lang.makeThrow("'%s' should be a directory!", d);
        }
        return d;
    }

    public static File findFile(String path, ClassLoader klassLoader, String enc) {
        if (null == (path = Disks.absolute(path, klassLoader, enc))) {
            return null;
        }
        return new File(path);
    }

    public static File findFile(String path, String enc) {
        return Files.findFile(path, ClassTools.getClassLoader(), enc);
    }

    public static File findFile(String path, ClassLoader klassLoader) {
        return Files.findFile(path, klassLoader, Encoding.defaultEncoding());
    }

    public static File[] ls(File d, final Pattern p, final boolean exclude, LsMode mode) {
        if (null == p) {
            return d.listFiles();
        }
        if (null == mode || LsMode.ALL == mode) {
            return d.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return p.matcher(f.getName()).find() ^ exclude;
                }
            });
        }
        if (LsMode.FILE == mode) {
            return d.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (!f.isFile()) {
                        return false;
                    }
                    return p.matcher(f.getName()).find() ^ exclude;
                }
            });
        }
        if (LsMode.DIR == mode) {
            return d.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (!f.isDirectory()) {
                        return false;
                    }
                    return p.matcher(f.getName()).find() ^ exclude;
                }
            });
        }
        throw Lang.impossible();
    }

    public static File[] ls(File d, String regex, LsMode mode) {
        boolean exclude = false;
        Pattern p = null;
        if (!Strings.isBlank(regex)) {
            exclude = regex.startsWith("!");
            if (exclude) {
                regex = Strings.trim(regex.substring(1));
            }
            p = Pattern.compile(regex);
        }
        return Files.ls(d, p, exclude, mode);
    }

    public static File[] ls(String path, String regex, LsMode mode) {
        return Files.ls(Files.checkFile(path), regex, mode);
    }

    public static File[] lsFile(File d, String regex) {
        return Files.ls(d, regex, LsMode.FILE);
    }

    public static File[] lsFile(String path, String regex) {
        return Files.ls(path, regex, LsMode.FILE);
    }

    public static File[] lsDir(File d, String regex) {
        return Files.ls(d, regex, LsMode.DIR);
    }

    public static File[] lsDir(String path, String regex) {
        return Files.ls(path, regex, LsMode.DIR);
    }

    public static File[] lsAll(File d, String regex) {
        return Files.ls(d, regex, LsMode.ALL);
    }

    public static File[] lsAll(String path, String regex) {
        return Files.ls(path, regex, LsMode.ALL);
    }

    public static File findFile(String path) {
        return Files.findFile(path, ClassTools.getClassLoader(), Encoding.defaultEncoding());
    }

    public static File checkFile(String path) {
        File f = Files.findFile(path);
        if (null == f) {
            throw Lang.makeThrow("Fail to found file '%s'", path);
        }
        return f;
    }

    public static InputStream findFileAsStream(String path, Class<?> klass, String enc) {
        File f = new File(path);
        if (f.exists()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e1) {
                return null;
            }
        }
        if (null != klass) {
            InputStream ins = klass.getClassLoader().getResourceAsStream(path);
            if (null == ins) {
                ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
            if (null != ins) {
                return ins;
            }
        }
        return ClassLoader.getSystemResourceAsStream(path);
    }

    public static InputStream findFileAsStream(String path, String enc) {
        return Files.findFileAsStream(path, Files.class, enc);
    }

    public static InputStream findFileAsStream(String path, Class<?> klass) {
        return Files.findFileAsStream(path, klass, Encoding.defaultEncoding());
    }

    public static InputStream findFileAsStream(String path) {
        return Files.findFileAsStream(path, Files.class, Encoding.defaultEncoding());
    }

    public static boolean isDirectory(File f) {
        if (null == f) {
            return false;
        }
        if (!f.exists()) {
            return false;
        }
        return f.isDirectory();
    }

    public static boolean isFile(File f) {
        return null != f && f.exists() && f.isFile();
    }

    public static boolean createNewFile(File f) throws IOException {
        if (null == f || f.exists()) {
            return false;
        }
        Files.makeDir(f.getParentFile());
        return f.createNewFile();
    }

    public static boolean makeDir(File dir) {
        if (null == dir || dir.exists()) {
            return false;
        }
        return dir.mkdirs();
    }

    public static boolean deleteDir(File dir) {
        if (null == dir || !dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("\"" + dir.getAbsolutePath() + "\" should be a directory!");
        }
        File[] files = dir.listFiles();
        boolean re = false;
        if (null != files) {
            if (files.length == 0) {
                return dir.delete();
            }
            for (File f : files) {
                if (f.isDirectory()) {
                    re |= Files.deleteDir(f);
                    continue;
                }
                re |= Files.deleteFile(f);
            }
            re |= dir.delete();
        }
        return re;
    }

    public static boolean deleteFile(File f) {
        if (null == f) {
            return false;
        }
        return f.delete();
    }

    public static boolean clearDir(File dir) {
        if (null == dir) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        File[] fs = dir.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (f.isFile()) {
                    Files.deleteFile(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                Files.deleteDir(f);
            }
        }
        return true;
    }

    public static boolean copyFile(File src, File target) throws IOException {
        return Files.copyFile(src, target, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File target, long count) throws IOException {
        if (src == null || target == null || !src.exists()) {
            return false;
        }
        if (!target.exists() && !Files.createNewFile(target)) {
            return false;
        }
        if (count == 0L) {
            return true;
        }
        FileInputStream ins = null;
        FileOutputStream ops = null;
        FileChannel in = null;
        FileChannel out = null;
        try {
            ins = new FileInputStream(src);
            ops = new FileOutputStream(target);
            in = ins.getChannel();
            out = ops.getChannel();
            long maxCount = in.size();
            if (count < 0L || count > maxCount) {
                count = maxCount;
            }
            in.transferTo(0L, count, out);
        }
        catch (Throwable throwable) {
            Streams.safeClose(out);
            Streams.safeFlush(ops);
            Streams.safeClose(ops);
            Streams.safeClose(in);
            Streams.safeClose(ins);
            throw throwable;
        }
        Streams.safeClose(out);
        Streams.safeFlush(ops);
        Streams.safeClose(ops);
        Streams.safeClose(in);
        Streams.safeClose(ins);
        return target.setLastModified(src.lastModified());
    }

    public static boolean copyFileWithoutException(File src, File target, long count) {
        try {
            return Files.copyFile(src, target, -1L);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static boolean copy(File src, File target) {
        try {
            if (src.isDirectory()) {
                return Files.copyDir(src, target);
            }
            return Files.copyFile(src, target);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static boolean copyDir(File src, File target) throws IOException {
        if (src == null || target == null || !src.exists()) {
            return false;
        }
        if (!src.isDirectory()) {
            throw new IOException(src.getAbsolutePath() + " should be a directory!");
        }
        if (!target.exists() && !Files.makeDir(target)) {
            return false;
        }
        boolean re = true;
        File[] files = src.listFiles();
        if (null != files) {
            for (File f : files) {
                if (f.isFile()) {
                    re &= Files.copyFile(f, new File(target.getAbsolutePath() + "/" + f.getName()));
                    continue;
                }
                re &= Files.copyDir(f, new File(target.getAbsolutePath() + "/" + f.getName()));
            }
        }
        return re;
    }

    public static boolean move(File src, File target) throws IOException {
        if (src == null || target == null) {
            return false;
        }
        Files.makeDir(target.getParentFile());
        if (src.isDirectory()) {
            src = new File(src.getCanonicalPath() + File.separator);
            target = new File(target.getCanonicalPath() + File.separator);
        }
        return src.renameTo(target);
    }

    public static boolean rename(File src, String newName) {
        if (src == null || newName == null) {
            return false;
        }
        if (src.exists()) {
            File newFile = new File(src.getParent() + "/" + newName);
            if (newFile.exists()) {
                return false;
            }
            Files.makeDir(newFile.getParentFile());
            return src.renameTo(newFile);
        }
        return false;
    }

    public static String renamePath(String path, String newName) {
        int pos;
        if (!Strings.isBlank(path) && (pos = path.replace('\\', '/').lastIndexOf(47)) > 0) {
            return path.substring(0, pos) + "/" + newName;
        }
        return newName;
    }

    public static String getParent(String path) {
        if (Strings.isBlank(path)) {
            return path;
        }
        int pos = path.replace('\\', '/').lastIndexOf(47);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        return "/";
    }

    public static String getName(File f) {
        return Files.getName(f.getPath());
    }

    public static String getName(String path) {
        int pos;
        if (!Strings.isBlank(path) && (pos = path.replace('\\', '/').lastIndexOf(47)) != -1) {
            return path.substring(pos + 1);
        }
        return path;
    }

    public static String getAbsPath(File f) {
        return Files.formedPath(f.getAbsolutePath());
    }

    public static String formedPath(String path) {
        if (null == path) {
            return null;
        }
        return path.replace('\\', '/');
    }

    public static void cleanAllFolderInSubFolderes(File dir, String name) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File d : files) {
            if (!d.isDirectory()) continue;
            if (d.getName().equalsIgnoreCase(name)) {
                Files.deleteDir(d);
                continue;
            }
            Files.cleanAllFolderInSubFolderes(d, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEquals(File f1, File f2) {
        if (null == f1 || null == f2 || !f1.isFile() || !f2.isFile()) {
            return false;
        }
        InputStream ins1 = null;
        InputStream ins2 = null;
        try {
            ins1 = Streams.fileIn(f1);
            ins2 = Streams.fileIn(f2);
            boolean bl = Streams.equals(ins1, ins2);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Streams.safeClose(ins1);
            Streams.safeClose(ins2);
        }
    }

    public static File getFile(File dir, String path) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return new File(dir.getAbsolutePath() + "/" + path);
            }
            return new File(dir.getParent() + "/" + path);
        }
        throw Lang.makeThrow("dir noexists: %s", dir);
    }

    public static File[] dirs(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && f.isDirectory() && !f.getName().startsWith(".");
            }
        });
    }

    public static File[] scanDirs(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        list.add(dir);
        Files.scanDirs(dir, list);
        return list.toArray(new File[list.size()]);
    }

    private static void scanDirs(File rootDir, List<File> list) {
        File[] dirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && f.isDirectory() && !f.getName().startsWith(".");
            }
        });
        if (dirs != null) {
            for (File dir : dirs) {
                Files.scanDirs(dir, list);
                list.add(dir);
            }
        }
    }

    public static File[] files(File dir, final String suffix) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && f.isFile() && (null == suffix || f.getName().endsWith(suffix));
            }
        });
    }

    public static boolean equals(File f1, File f2) {
        return Files.isEquals(f1, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyOnWrite(File f, Object obj) {
        File tmp = new File(f.getAbsolutePath() + ".new");
        File tmp2 = new File(f.getAbsolutePath() + ".old");
        tmp2.delete();
        try {
            Files.write(tmp, obj);
            boolean flag = false;
            if (f.exists()) {
                flag = f.renameTo(tmp2);
            }
            if (tmp.renameTo(f)) {
                tmp2.delete();
                boolean bl = true;
                return bl;
            }
            if (flag) {
                tmp2.renameTo(f);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            tmp.delete();
        }
    }

    public static boolean copyOnWrite(String path, Object obj) {
        return Files.copyOnWrite(new File(path), obj);
    }

    public static List<String> readLines(File f) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = Streams.buffr(Streams.fileInr(f));
            while (br.ready()) {
                lines.add(br.readLine());
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(br);
        }
        return lines;
    }

    public static void readLine(File f, Callback<String> callback) {
        BufferedReader br = null;
        try {
            br = Streams.buffr(Streams.fileInr(f));
            while (br.ready()) {
                callback.invoke(br.readLine());
            }
        }
        catch (ExitLoop exitLoop) {
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(br);
        }
    }

    public static int readRange(File f, int pos, byte[] buf, int at, int len) {
        try {
            if (f == null || !f.exists()) {
                return 0;
            }
            long fsize = f.length();
            if ((long)pos > fsize) {
                return 0;
            }
            if ((long)(pos + (len = Math.min(len, buf.length - at))) > fsize) {
                len = (int)(fsize - (long)pos);
            }
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            raf.seek(pos);
            raf.readFully(buf, at, len);
            raf.close();
            return len;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int writeRange(File f, int pos, byte[] buf, int at, int len) {
        try {
            if (f == null || !f.exists()) {
                return 0;
            }
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            raf.seek(pos);
            raf.write(buf, at, len);
            raf.close();
            return len;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static enum LsMode {
        FILE,
        DIR,
        ALL;

    }
}

