/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Regex;

public abstract class Nums {
    public static float precision(float n, int dp) {
        if (0 == dp) {
            return Math.round(n);
        }
        if (1 == dp) {
            return (float)Math.round(n * 10.0f) / 10.0f;
        }
        if (2 == dp) {
            return (float)Math.round(n * 100.0f) / 100.0f;
        }
        if (3 == dp) {
            return (float)Math.round(n * 1000.0f) / 1000.0f;
        }
        float p = (float)Math.pow(10.0, dp);
        return (float)Math.round(n * p) / p;
    }

    public static double precision(double n, int dp) {
        if (0 == dp) {
            return Math.round(n);
        }
        if (1 == dp) {
            return (double)Math.round(n * 10.0) / 10.0;
        }
        if (2 == dp) {
            return (double)Math.round(n * 100.0) / 100.0;
        }
        if (3 == dp) {
            return (double)Math.round(n * 1000.0) / 1000.0;
        }
        double p = Math.pow(10.0, dp);
        return (double)Math.round(n * p) / p;
    }

    public static int gcd(int a, int b) {
        a = Math.round(a);
        if ((b = Math.round(b)) != 0) {
            return Nums.gcd(b, a % b);
        }
        return a;
    }

    public static int gcds(int ... list) {
        if (list.length == 0) {
            return Integer.MIN_VALUE;
        }
        if (list.length == 1) {
            return list[0];
        }
        int gcd = Nums.gcd(list[0], list[1]);
        for (int i = 2; i < list.length; ++i) {
            gcd = Nums.gcd(gcd, list[i]);
        }
        return gcd;
    }

    public static int lcm(int a, int b) {
        a = Math.round(a);
        b = Math.round(b);
        return a * b / Nums.gcd(a, b);
    }

    public static int lcms(int ... list) {
        if (list.length == 0) {
            return Integer.MAX_VALUE;
        }
        if (list.length == 1) {
            return list[0];
        }
        int lcm = Nums.lcm(list[0], list[1]);
        for (int i = 2; i < list.length; ++i) {
            lcm = Nums.lcm(lcm, list[i]);
        }
        return lcm;
    }

    public static double dimension(String v, double base) {
        try {
            Integer nb = Integer.valueOf(v);
            return nb.intValue();
        }
        catch (NumberFormatException nb) {
            try {
                Double nb2 = Double.valueOf(v);
                return nb2 * base;
            }
            catch (NumberFormatException nb2) {
                Pattern p = Regex.getPattern("^([0-9.]{1,})%$");
                Matcher m = p.matcher(v);
                if (m.find()) {
                    Double nb3 = Double.valueOf(m.group(1));
                    return nb3 / 100.0 * base;
                }
                throw Lang.makeThrow("fail to dimension : " + v, new Object[0]);
            }
        }
    }

    public static int dimension(String v, int base) {
        return (int)Nums.dimension(v, (double)base);
    }

    public static int sum(int ... nbs) {
        int re = 0;
        for (int nb : nbs) {
            re += nb;
        }
        return re;
    }

    public static Radix evalRadix(String str) {
        if (str.startsWith("0x")) {
            return new Radix(str.substring(2), 16);
        }
        if (str.startsWith("0") && str.length() > 1) {
            return new Radix(str.substring(1), 8);
        }
        if (str.startsWith("0b")) {
            return new Radix(str.substring(2), 2);
        }
        return new Radix(str, 10);
    }

    public static int[] splitInt(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        int[] ns = new int[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Integer.parseInt(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = -1;
            }
        }
        return ns;
    }

    public static long[] splitLong(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        long[] ns = new long[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Long.parseLong(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = -1L;
            }
        }
        return ns;
    }

    public static float[] splitFloat(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        float[] ns = new float[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Float.parseFloat(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = 0.0f;
            }
        }
        return ns;
    }

    public static double[] splitDouble(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        double[] ns = new double[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Long.parseLong(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = -1.0;
            }
        }
        return ns;
    }

    public static boolean[] splitBoolean(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        boolean[] ns = new boolean[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Regex.match("^(1|yes|true|on)$", ss[i].toLowerCase());
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = false;
            }
        }
        return ns;
    }

    public static int indexOf(int[] arr, int v) {
        return Nums.indexOf(arr, v, 0);
    }

    public static int indexOf(int[] arr, int v, int off) {
        if (null != arr) {
            for (int i = off; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] arr, int v) {
        if (null != arr) {
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] arr, char v) {
        if (null != arr) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] arr, char v, int off) {
        if (null != arr) {
            for (int i = off; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] arr, char v) {
        if (null != arr) {
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(long[] arr, long v) {
        return Nums.indexOf(arr, v, 0);
    }

    public static int indexOf(long[] arr, long v, int off) {
        if (null != arr) {
            for (int i = off; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] arr, long v) {
        if (null != arr) {
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int[] array(int ... is) {
        return is;
    }

    public static boolean isin(int[] arr, int i) {
        return Nums.indexOf(arr, i) >= 0;
    }

    public static int[] join(int[] arr, int ... is) {
        if (null == arr) {
            return is;
        }
        int length = arr.length + is.length;
        int[] re = new int[length];
        System.arraycopy(arr, 0, re, 0, arr.length);
        int i = arr.length;
        for (int num : is) {
            re[i++] = num;
        }
        return re;
    }

    public static long[] arrayL(long ... is) {
        return is;
    }

    public static boolean isin(long[] arr, long i) {
        return Nums.indexOf(arr, i) >= 0;
    }

    public static long[] join(long[] arr, long ... is) {
        if (null == arr) {
            return is;
        }
        int length = arr.length + is.length;
        long[] re = new long[length];
        System.arraycopy(arr, 0, re, 0, arr.length);
        int i = arr.length;
        for (long num : is) {
            re[i++] = num;
        }
        return re;
    }

    public static char[] arrayC(char ... is) {
        return is;
    }

    public static boolean isin(char[] arr, char i) {
        return Nums.indexOf(arr, i) >= 0;
    }

    public static char[] join(char[] arr, char ... is) {
        if (null == arr) {
            return is;
        }
        int length = arr.length + is.length;
        char[] re = new char[length];
        System.arraycopy(arr, 0, re, 0, arr.length);
        int i = arr.length;
        for (char num : is) {
            re[i++] = num;
        }
        return re;
    }

    public static class Radix {
        public int radix;
        public String val;

        Radix(String val, int radix) {
            this.val = val;
            this.radix = radix;
        }
    }
}

