/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.stream;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.nutz.lang.Streams;

public class FileChannelInputStream
extends InputStream {
    private FileInputStream ins;
    private FileChannel chan;
    private ByteBuffer buf;
    private int bufLen;
    private int bufPos;

    public FileChannelInputStream(FileInputStream ins) {
        this.ins = ins;
        this.chan = ins.getChannel();
    }

    public FileChannelInputStream(FileChannel chan) {
        this.chan = chan;
    }

    @Override
    public long skip(long n) throws IOException {
        long pos = this.chan.position();
        if (null != this.buf) {
            pos = pos - (long)this.bufLen + (long)this.bufPos;
            this.buf = null;
            this.bufLen = 0;
            this.bufPos = 0;
        }
        long pos2 = Math.max(pos + n, 0L);
        pos2 = Math.min(pos2, this.chan.size());
        this.chan.position(pos2);
        return pos2 - pos;
    }

    @Override
    public int read() throws IOException {
        if (null == this.buf || this.bufPos >= this.bufLen) {
            this.buf = ByteBuffer.allocate(8192);
            this.bufLen = this.chan.read(this.buf);
            this.bufPos = 0;
        }
        return this.buf.getInt(this.bufPos++);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (null != this.buf && this.bufPos < this.bufLen) {
            int max = Math.min(len, this.bufLen - this.bufPos);
            this.buf.get(b, off, len);
            this.bufPos += max;
            if (this.bufPos >= this.bufLen) {
                this.buf = null;
                this.bufPos = 0;
                this.bufLen = 0;
            }
            return max;
        }
        ByteBuffer bb = ByteBuffer.wrap(b, off, len);
        return this.chan.read(bb);
    }

    @Override
    public int available() throws IOException {
        int remain = this.bufLen - this.bufPos;
        return remain + (int)(this.chan.size() - this.chan.position());
    }

    @Override
    public void close() throws IOException {
        Streams.safeClose(this.chan);
        Streams.safeClose(this.ins);
    }
}

