/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.stream;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.nutz.lang.Streams;

public class FileChannelOutputStream
extends OutputStream {
    private FileOutputStream ops;
    private FileChannel chan;
    private ByteBuffer buf;

    public FileChannelOutputStream(FileOutputStream ops) {
        this.ops = ops;
        this.chan = ops.getChannel();
    }

    public FileChannelOutputStream(FileChannel chan) {
        this.chan = chan;
    }

    @Override
    public void write(int b) throws IOException {
        if (null == this.buf) {
            this.buf = ByteBuffer.allocate(8192);
            if (this.buf.isReadOnly()) {
                this.buf.flip();
            }
        }
        if (!this.buf.hasRemaining()) {
            this.flushBuffer();
        }
        this.buf.putInt(b);
    }

    private void flushBuffer() throws IOException {
        if (!this.buf.isReadOnly()) {
            this.buf.flip();
        }
        this.chan.write(this.buf);
        this.buf.clear();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (null != this.buf && this.buf.position() > 0) {
            this.flushBuffer();
        }
        ByteBuffer bb = ByteBuffer.wrap(b, off, len);
        this.chan.write(bb);
    }

    @Override
    public void flush() throws IOException {
        if (null != this.buf) {
            this.flushBuffer();
        }
        this.chan.force(false);
        Streams.safeFlush(this.ops);
    }

    @Override
    public void close() throws IOException {
        Streams.safeClose(this.chan);
        Streams.safeClose(this.ops);
    }
}

