/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.tmpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.tmpl.StrEleConvertor;
import org.nutz.lang.tmpl.StrFormatConvertor;
import org.nutz.lang.tmpl.StrMappingConvertor;
import org.nutz.lang.tmpl.StrReplaceConvertor;
import org.nutz.lang.tmpl.StrTrimConvertor;
import org.nutz.lang.tmpl.TmplDynamicEle;

class TmplStringEle
extends TmplDynamicEle {
    private List<StrEleConvertor> convertors;

    public TmplStringEle(String key, String fmt, String dft) {
        super(null, key, null, dft);
        this.fmt = Strings.sNull(fmt, null);
        this.parseFormat(this.fmt);
    }

    public void parseFormat(String fmt) {
        if (null == fmt) {
            this.convertors = null;
            return;
        }
        String[] ss = Strings.split(this.fmt, true, ';');
        this.convertors = new ArrayList<StrEleConvertor>(ss.length);
        for (String s : ss) {
            String input;
            if (s.equals("@trim")) {
                this.convertors.add(new StrTrimConvertor());
                continue;
            }
            if (s.startsWith("@replace")) {
                input = s.substring("@replace".length());
                this.convertors.add(new StrReplaceConvertor(input));
                continue;
            }
            if (s.startsWith(":")) {
                input = s.substring(1);
                this.convertors.add(new StrMappingConvertor(input));
                continue;
            }
            this.convertors.add(new StrFormatConvertor(s));
        }
    }

    @Override
    protected String _val(Object val) {
        if (null == val) {
            return null;
        }
        if (null != val) {
            if (val.getClass().isArray()) {
                return Lang.concat((Object)", ", (Object[])val).toString();
            }
            if (val instanceof Collection) {
                return Strings.join(", ", (Collection)val);
            }
        }
        String re = val.toString();
        if (null != this.convertors && !this.convertors.isEmpty()) {
            for (StrEleConvertor co : this.convertors) {
                re = co.process(re);
            }
        }
        return re;
    }
}

