/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.validate;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nutz.lang.util.NutMap;
import org.nutz.validate.NutValidateException;
import org.nutz.validate.NutValidator;
import org.nutz.validate.impl.BoolValueValidator;
import org.nutz.validate.impl.DateRangeValidator;
import org.nutz.validate.impl.IntEnumValidator;
import org.nutz.validate.impl.IntRangeValidator;
import org.nutz.validate.impl.IntValueValidator;
import org.nutz.validate.impl.MaxLengthValidator;
import org.nutz.validate.impl.MinLengthValidator;
import org.nutz.validate.impl.NotNullValidator;
import org.nutz.validate.impl.RegexValidator;
import org.nutz.validate.impl.StrEnumValidator;
import org.nutz.validate.impl.StrValueValidator;
import org.nutz.validate.impl.TrimValidator;
import org.nutz.validate.impl.WildcardValidator;

public class NutValidate {
    private List<NutValidator> items = new LinkedList<NutValidator>();

    public NutValidate() {
    }

    public NutValidate(Map<String, Object> map) {
        this();
        this.items.clear();
        this.addAll(map);
        this.ready();
    }

    public NutValidate(String str) {
        this();
        this.add(new NotNullValidator());
        if (str.startsWith("*") || str.endsWith("*")) {
            this.add(new WildcardValidator(str));
        } else if (str.startsWith("^") || str.startsWith("!^")) {
            this.add(new RegexValidator(str));
        } else if (str.matches("^[\\[(].+[\\])]$")) {
            if (str.indexOf(47) >= 0 || str.indexOf(45) >= 0) {
                this.add(new DateRangeValidator(str));
            } else {
                this.add(new IntRangeValidator(str));
            }
        } else if (str.matches("^\\d+$")) {
            this.add(new IntValueValidator(str));
        } else {
            this.add(new StrValueValidator(str));
        }
    }

    public NutValidate addAll(Map<String, Object> map) {
        NutMap m2 = NutMap.WRAP(map);
        for (String key : m2.keySet()) {
            if ("trim".equals(key)) {
                this.items.add(new TrimValidator());
                continue;
            }
            if ("intRange".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new IntRangeValidator(str));
                continue;
            }
            if ("dateRange".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new DateRangeValidator(str));
                continue;
            }
            if ("regex".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new RegexValidator(str));
                continue;
            }
            if ("intEnum".equals(key)) {
                Object val = m2.get(key);
                this.items.add(new IntEnumValidator(val));
                continue;
            }
            if ("strEnum".equals(key)) {
                Object val = m2.get(key);
                this.items.add(new StrEnumValidator(val));
                continue;
            }
            if ("wildcard".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new WildcardValidator(str));
                continue;
            }
            if ("intValue".equals(key)) {
                Object val = m2.get(key);
                this.items.add(new IntValueValidator(val));
                continue;
            }
            if ("strValue".equals(key)) {
                Object val = m2.get(key);
                this.items.add(new StrValueValidator(val));
                continue;
            }
            if ("boolValue".equals(key)) {
                Object val = m2.get(key);
                this.items.add(new BoolValueValidator(val));
                continue;
            }
            if ("notNull".equals(key)) {
                this.items.add(new NotNullValidator());
                continue;
            }
            if ("maxLength".equals(key)) {
                int len = m2.getInt(key);
                this.items.add(new MaxLengthValidator(len));
                continue;
            }
            if (!"minLength".equals(key)) continue;
            int len = m2.getInt(key);
            this.items.add(new MinLengthValidator(len));
        }
        return this;
    }

    public NutValidate add(NutValidator ... nvs) {
        for (NutValidator nv : nvs) {
            this.items.add(nv);
        }
        return this;
    }

    public NutValidate ready() {
        Collections.sort(this.items, new Comparator<NutValidator>(){

            @Override
            public int compare(NutValidator v1, NutValidator v2) {
                return v1.order() - v2.order();
            }
        });
        return this;
    }

    public NutValidate reset() {
        this.items.clear();
        return this;
    }

    public Object check(Object val) throws NutValidateException {
        Object re = val;
        for (NutValidator nv : this.items) {
            re = nv.check(re);
        }
        return re;
    }

    public boolean match(Object val) {
        try {
            this.check(val);
            return true;
        }
        catch (NutValidateException e) {
            return false;
        }
    }
}

