/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import lombok.NonNull;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.JavacHandlerUtil;

@HandlerPriority(value=512)
public class HandleNonNull
extends JavacAnnotationHandler<NonNull> {
    @Override
    public void handle(AnnotationValues<NonNull> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JCTree.JCMethodDecl declaration;
        if (((JavacNode)annotationNode.up()).getKind() == AST.Kind.FIELD) {
            try {
                if (Javac.isPrimitive(((JCTree.JCVariableDecl)((JavacNode)annotationNode.up()).get()).vartype)) {
                    annotationNode.addWarning("@NonNull is meaningless on a primitive.");
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            return;
        }
        if (((JavacNode)annotationNode.up()).getKind() != AST.Kind.ARGUMENT) {
            return;
        }
        try {
            declaration = (JCTree.JCMethodDecl)((JavacNode)((JavacNode)annotationNode.up()).up()).get();
        }
        catch (Exception e) {
            return;
        }
        if (declaration.body == null) {
            annotationNode.addWarning("@NonNull is meaningless on a parameter of an abstract method.");
            return;
        }
        JCTree.JCStatement nullCheck = JavacHandlerUtil.recursiveSetGeneratedBy(JavacHandlerUtil.generateNullCheck(annotationNode.getTreeMaker(), (JavacNode)annotationNode.up()), ast, annotationNode.getContext());
        if (nullCheck == null) {
            annotationNode.addWarning("@NonNull is meaningless on a primitive.");
            return;
        }
        List<JCTree.JCStatement> statements = declaration.body.stats;
        String expectedName = ((JavacNode)annotationNode.up()).getName();
        List<JCTree.JCStatement> stats = statements;
        int idx = 0;
        while (stats.size() > idx) {
            JCTree.JCStatement stat;
            if (JavacHandlerUtil.isConstructorCall(stat = stats.get(idx++))) continue;
            if (stat instanceof JCTree.JCTry) {
                stats = ((JCTree.JCTry)stat).body.stats;
                idx = 0;
                continue;
            }
            if (stat instanceof JCTree.JCSynchronized) {
                stats = ((JCTree.JCSynchronized)stat).body.stats;
                idx = 0;
                continue;
            }
            String varNameOfNullCheck = this.returnVarNameIfNullCheck(stat);
            if (varNameOfNullCheck == null) break;
            if (!varNameOfNullCheck.equals(expectedName)) continue;
            return;
        }
        List<JCTree.JCStatement> tail = statements;
        List<JCTree.JCStatement> head = List.nil();
        for (JCTree.JCStatement stat : statements) {
            if (!(JavacHandlerUtil.isConstructorCall(stat) || JavacHandlerUtil.isGenerated(stat) && this.isNullCheck(stat))) break;
            tail = tail.tail;
            head = head.prepend(stat);
        }
        List<JCTree.JCStatement> newList = tail.prepend(nullCheck);
        for (JCTree.JCStatement stat : head) {
            newList = newList.prepend(stat);
        }
        declaration.body.stats = newList;
    }

    public boolean isNullCheck(JCTree.JCStatement stat) {
        return this.returnVarNameIfNullCheck(stat) != null;
    }

    public String returnVarNameIfNullCheck(JCTree.JCStatement stat) {
        if (!(stat instanceof JCTree.JCIf)) {
            return null;
        }
        JCTree.JCStatement then = ((JCTree.JCIf)stat).thenpart;
        if (then instanceof JCTree.JCBlock) {
            List<JCTree.JCStatement> stats = ((JCTree.JCBlock)then).stats;
            if (stats.length() == 0) {
                return null;
            }
            then = stats.get(0);
        }
        if (!(then instanceof JCTree.JCThrow)) {
            return null;
        }
        JCTree.JCExpression cond = ((JCTree.JCIf)stat).cond;
        while (cond instanceof JCTree.JCParens) {
            cond = ((JCTree.JCParens)cond).expr;
        }
        if (!(cond instanceof JCTree.JCBinary)) {
            return null;
        }
        JCTree.JCBinary bin = (JCTree.JCBinary)cond;
        if (!Javac.CTC_EQUAL.equals(JavacTreeMaker.TreeTag.treeTag(bin))) {
            return null;
        }
        if (!(bin.lhs instanceof JCTree.JCIdent)) {
            return null;
        }
        if (!(bin.rhs instanceof JCTree.JCLiteral)) {
            return null;
        }
        if (!Javac.CTC_BOT.equals(JavacTreeMaker.TypeTag.typeTag(bin.rhs))) {
            return null;
        }
        return ((JCTree.JCIdent)bin.lhs).name.toString();
    }
}

