/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation;

import org.redisson.RedissonKeys;
import org.redisson.RedissonLock;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.RedissonTransactionalWriteLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class ClearExpireOperation
extends TransactionalOperation {
    private String writeLockName;
    private String lockName;
    private String transactionId;

    public ClearExpireOperation(String name, String lockName, long threadId, String transactionId) {
        super(name, null, threadId);
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    public ClearExpireOperation(String name, String lockName, String writeLockName, long threadId, String transactionId) {
        super(name, null, threadId);
        this.lockName = lockName;
        this.transactionId = transactionId;
        this.writeLockName = writeLockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock;
        RedissonKeys keys = new RedissonKeys(commandExecutor);
        keys.clearExpireAsync(this.getName());
        if (this.lockName != null) {
            lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
        if (this.writeLockName != null) {
            lock = new RedissonTransactionalWriteLock(commandExecutor, this.writeLockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock;
        if (this.lockName != null) {
            lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
        if (this.writeLockName != null) {
            lock = new RedissonTransactionalWriteLock(commandExecutor, this.writeLockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
    }

    public String getLockName() {
        return this.lockName;
    }
}

