/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vertexai.embedding;

import com.google.cloud.vertexai.VertexAI;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.autoconfigure.vertexai.embedding.VertexAiEmbeddingConnectionProperties;
import org.springframework.ai.autoconfigure.vertexai.embedding.VertexAiMultimodalEmbeddingProperties;
import org.springframework.ai.autoconfigure.vertexai.embedding.VertexAiTextEmbeddingProperties;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.vertexai.embedding.VertexAiEmbeddingConnectionDetails;
import org.springframework.ai.vertexai.embedding.multimodal.VertexAiMultimodalEmbeddingModel;
import org.springframework.ai.vertexai.embedding.text.VertexAiTextEmbeddingModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={VertexAI.class, VertexAiTextEmbeddingModel.class})
@EnableConfigurationProperties(value={VertexAiEmbeddingConnectionProperties.class, VertexAiTextEmbeddingProperties.class, VertexAiMultimodalEmbeddingProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class})
public class VertexAiEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAiEmbeddingConnectionDetails connectionDetails(VertexAiEmbeddingConnectionProperties connectionProperties) {
        Assert.hasText((String)connectionProperties.getProjectId(), (String)"Vertex AI project-id must be set!");
        Assert.hasText((String)connectionProperties.getLocation(), (String)"Vertex AI location must be set!");
        VertexAiEmbeddingConnectionDetails.Builder connectionBuilder = VertexAiEmbeddingConnectionDetails.builder().projectId(connectionProperties.getProjectId()).location(connectionProperties.getLocation());
        if (StringUtils.hasText((String)connectionProperties.getApiEndpoint())) {
            connectionBuilder.apiEndpoint(connectionProperties.getApiEndpoint());
        }
        return connectionBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.embedding.text", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiTextEmbeddingModel textEmbedding(VertexAiEmbeddingConnectionDetails connectionDetails, VertexAiTextEmbeddingProperties textEmbeddingProperties, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        VertexAiTextEmbeddingModel embeddingModel = new VertexAiTextEmbeddingModel(connectionDetails, textEmbeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((VertexAiTextEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.embedding.multimodal", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiMultimodalEmbeddingModel multimodalEmbedding(VertexAiEmbeddingConnectionDetails connectionDetails, VertexAiMultimodalEmbeddingProperties multimodalEmbeddingProperties) throws IOException {
        return new VertexAiMultimodalEmbeddingModel(connectionDetails, multimodalEmbeddingProperties.getOptions());
    }
}

