/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.content.Content;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.document.id.IdGenerator;
import org.springframework.ai.document.id.RandomIdGenerator;
import org.springframework.util.Assert;

public final class SimpleVectorStoreContent
implements Content {
    private final String id;
    private final String text;
    private final Map<String, Object> metadata;
    private final float[] embedding;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SimpleVectorStoreContent(@JsonProperty(value="text") @JsonAlias(value={"content"}) String text, @JsonProperty(value="embedding") float[] embedding) {
        this(text, new HashMap<String, Object>(), embedding);
    }

    public SimpleVectorStoreContent(String text, Map<String, Object> metadata, float[] embedding) {
        this(text, metadata, (IdGenerator)new RandomIdGenerator(), embedding);
    }

    public SimpleVectorStoreContent(String text, Map<String, Object> metadata, IdGenerator idGenerator, float[] embedding) {
        this(idGenerator.generateId(new Object[]{text, metadata}), text, metadata, embedding);
    }

    public SimpleVectorStoreContent(String id, String text, Map<String, Object> metadata, float[] embedding) {
        Assert.hasText((String)id, (String)"id must not be null or empty");
        Assert.notNull((Object)text, (String)"content must not be null");
        Assert.notNull(metadata, (String)"metadata must not be null");
        Assert.notNull((Object)embedding, (String)"embedding must not be null");
        Assert.isTrue((embedding.length > 0 ? 1 : 0) != 0, (String)"embedding vector must not be empty");
        this.id = id;
        this.text = text;
        this.metadata = Map.copyOf(metadata);
        this.embedding = Arrays.copyOf(embedding, embedding.length);
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public float[] getEmbedding() {
        return Arrays.copyOf(this.embedding, this.embedding.length);
    }

    public Document toDocument(Double score) {
        HashMap<String, Object> metadata = new HashMap<String, Object>(this.metadata);
        metadata.put(DocumentMetadata.DISTANCE.value(), 1.0 - score);
        return Document.builder().id(this.id).text(this.text).metadata(metadata).score(score).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleVectorStoreContent that = (SimpleVectorStoreContent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.text, that.text) && Objects.equals(this.metadata, that.metadata) && Arrays.equals(this.embedding, that.embedding);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.text);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Arrays.hashCode(this.embedding);
        return result;
    }

    public String toString() {
        return "SimpleVectorStoreContent{id='" + this.id + "', content='" + this.text + "', metadata=" + String.valueOf(this.metadata) + ", embedding=" + Arrays.toString(this.embedding) + "}";
    }
}

