/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.observation;

import io.micrometer.observation.Observation;
import java.util.List;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class VectorStoreObservationContext
extends Observation.Context {
    private final String databaseSystem;
    private final String operationName;
    @Nullable
    private String collectionName;
    @Nullable
    private Integer dimensions;
    @Nullable
    private String fieldName;
    @Nullable
    private String namespace;
    @Nullable
    private String similarityMetric;
    @Nullable
    private SearchRequest queryRequest;
    @Nullable
    private List<Document> queryResponse;

    public VectorStoreObservationContext(String databaseSystem, String operationName) {
        Assert.hasText((String)databaseSystem, (String)"databaseSystem cannot be null or empty");
        Assert.hasText((String)operationName, (String)"operationName cannot be null or empty");
        this.databaseSystem = databaseSystem;
        this.operationName = operationName;
    }

    public static Builder builder(String databaseSystem, String operationName) {
        return new Builder(databaseSystem, operationName);
    }

    public static Builder builder(String databaseSystem, Operation operation) {
        return VectorStoreObservationContext.builder(databaseSystem, operation.value);
    }

    public String getDatabaseSystem() {
        return this.databaseSystem;
    }

    public String getOperationName() {
        return this.operationName;
    }

    @Nullable
    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(@Nullable String collectionName) {
        this.collectionName = collectionName;
    }

    @Nullable
    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(@Nullable Integer dimensions) {
        this.dimensions = dimensions;
    }

    @Nullable
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(@Nullable String fieldName) {
        this.fieldName = fieldName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
    }

    @Nullable
    public String getSimilarityMetric() {
        return this.similarityMetric;
    }

    public void setSimilarityMetric(@Nullable String similarityMetric) {
        this.similarityMetric = similarityMetric;
    }

    @Nullable
    public SearchRequest getQueryRequest() {
        return this.queryRequest;
    }

    public void setQueryRequest(@Nullable SearchRequest queryRequest) {
        this.queryRequest = queryRequest;
    }

    @Nullable
    public List<Document> getQueryResponse() {
        return this.queryResponse;
    }

    public void setQueryResponse(@Nullable List<Document> queryResponse) {
        this.queryResponse = queryResponse;
    }

    public static class Builder {
        private final VectorStoreObservationContext context;

        public Builder(String databaseSystem, String operationName) {
            this.context = new VectorStoreObservationContext(databaseSystem, operationName);
        }

        public Builder collectionName(String collectionName) {
            this.context.setCollectionName(collectionName);
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.context.setDimensions(dimensions);
            return this;
        }

        public Builder fieldName(@Nullable String fieldName) {
            this.context.setFieldName(fieldName);
            return this;
        }

        public Builder namespace(String namespace) {
            this.context.setNamespace(namespace);
            return this;
        }

        public Builder queryRequest(SearchRequest request) {
            this.context.setQueryRequest(request);
            return this;
        }

        public Builder queryResponse(List<Document> documents) {
            this.context.setQueryResponse(documents);
            return this;
        }

        public Builder similarityMetric(String similarityMetric) {
            this.context.setSimilarityMetric(similarityMetric);
            return this;
        }

        public VectorStoreObservationContext build() {
            return this.context;
        }
    }

    public static enum Operation {
        ADD("add"),
        DELETE("delete"),
        QUERY("query");

        public final String value;

        private Operation(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

