/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.HandleAuthorizationDenied;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.ReflectiveMethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;

final class PreAuthorizeExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<ExpressionAttribute> {
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();
    private final SecurityAnnotationScanner<HandleAuthorizationDenied> handleAuthorizationDeniedScanner = SecurityAnnotationScanners.requireUnique(HandleAuthorizationDenied.class);
    private Function<Class<? extends MethodAuthorizationDeniedHandler>, MethodAuthorizationDeniedHandler> handlerResolver;
    private SecurityAnnotationScanner<PreAuthorize> preAuthorizeScanner = SecurityAnnotationScanners.requireUnique(PreAuthorize.class);

    PreAuthorizeExpressionAttributeRegistry() {
        this.handlerResolver = clazz -> new ReflectiveMethodAuthorizationDeniedHandler((Class<?>)clazz, PreAuthorizeAuthorizationManager.class);
    }

    @Override
    @NonNull
    ExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        PreAuthorize preAuthorize = this.findPreAuthorizeAnnotation(method, targetClass);
        if (preAuthorize == null) {
            return ExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression expression = this.getExpressionHandler().getExpressionParser().parseExpression(preAuthorize.value());
        MethodAuthorizationDeniedHandler handler = this.resolveHandler(method, targetClass);
        return new PreAuthorizeExpressionAttribute(expression, handler);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = this.targetClass(method, targetClass);
        HandleAuthorizationDenied deniedHandler = this.handleAuthorizationDeniedScanner.scan(method, targetClassToUse);
        if (deniedHandler != null) {
            return this.handlerResolver.apply(deniedHandler.handlerClass());
        }
        return this.defaultHandler;
    }

    private PreAuthorize findPreAuthorizeAnnotation(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = this.targetClass(method, targetClass);
        return this.preAuthorizeScanner.scan(method, targetClassToUse);
    }

    void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.handlerResolver = clazz -> this.resolveHandler(context, (Class<? extends MethodAuthorizationDeniedHandler>)clazz);
    }

    @Override
    void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.preAuthorizeScanner = SecurityAnnotationScanners.requireUnique(PreAuthorize.class, defaults);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(ApplicationContext context, Class<? extends MethodAuthorizationDeniedHandler> handlerClass) {
        if (handlerClass == this.defaultHandler.getClass()) {
            return this.defaultHandler;
        }
        Object[] beanNames = context.getBeanNamesForType(handlerClass);
        if (beanNames.length == 0) {
            throw new IllegalStateException("Could not find a bean of type " + handlerClass.getName());
        }
        if (beanNames.length > 1) {
            throw new IllegalStateException("Expected to find a single bean of type " + handlerClass.getName() + " but found " + Arrays.toString(beanNames));
        }
        return (MethodAuthorizationDeniedHandler)context.getBean(beanNames[0], handlerClass);
    }
}

