/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ReconnConf;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.AioListener;
import org.tio.core.maintain.MaintainUtils;
import org.tio.core.ssl.SslUtils;
import org.tio.utils.SystemTimer;

public class CloseRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(CloseRunnable.class);
    private ChannelContext channelContext;
    private Throwable throwable;
    private String remark;
    private boolean isNeedRemove;

    public CloseRunnable(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        this.channelContext = channelContext;
        this.throwable = throwable;
        this.remark = SslUtils.isSsl(channelContext) ? (remark == null ? "isHandshakeCompleted:" + channelContext.getSslFacadeContext().isHandshakeCompleted() : remark + "\u3002isHandshakeCompleted:" + channelContext.getSslFacadeContext().isHandshakeCompleted()) : remark;
        this.isNeedRemove = isNeedRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReentrantReadWriteLock.WriteLock writeLock;
            boolean isRemove;
            boolean isClientChannelContext;
            AioListener aioListener;
            GroupContext groupContext;
            block43: {
                block42: {
                    block39: {
                        block40: {
                            block41: {
                                groupContext = this.channelContext.getGroupContext();
                                aioListener = groupContext.getAioListener();
                                try {
                                    AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
                                    if (asynchronousSocketChannel != null && asynchronousSocketChannel.isOpen()) {
                                        try {
                                            asynchronousSocketChannel.close();
                                        }
                                        catch (Throwable e) {
                                            log.error(e.toString(), e);
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    log.error(e.toString(), e);
                                }
                                isClientChannelContext = this.channelContext instanceof ClientChannelContext;
                                isRemove = this.isNeedRemove;
                                if (!isRemove) {
                                    if (isClientChannelContext) {
                                        ClientChannelContext clientChannelContext = (ClientChannelContext)this.channelContext;
                                        if (!ReconnConf.isNeedReconn(clientChannelContext, false)) {
                                            isRemove = true;
                                        }
                                    } else {
                                        isRemove = true;
                                    }
                                }
                                try {
                                    this.channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                                    aioListener.onBeforeClose(this.channelContext, this.throwable, this.remark, isRemove);
                                }
                                catch (Throwable e) {
                                    log.error(e.toString(), e);
                                }
                                ReentrantReadWriteLock reentrantReadWriteLock = this.channelContext.getCloseLock();
                                writeLock = reentrantReadWriteLock.writeLock();
                                boolean isLock = writeLock.tryLock();
                                if (isLock) break block39;
                                if (!isRemove) break block40;
                                if (!this.channelContext.isRemoved()) break block41;
                                writeLock.unlock();
                                return;
                            }
                            writeLock.lock();
                            break block39;
                        }
                        writeLock.unlock();
                        return;
                    }
                    this.channelContext.traceClient(ChannelAction.UNCONNECT, null, null);
                    if (!this.channelContext.isClosed() || isRemove) break block42;
                    log.info("{}, {}\u5df2\u7ecf\u5173\u95ed\uff0c\u5907\u6ce8:{}\uff0c\u5f02\u5e38:{}", new Object[]{this.channelContext.getGroupContext(), this.channelContext, this.remark, this.throwable == null ? "\u65e0" : this.throwable.toString()});
                    writeLock.unlock();
                    return;
                }
                if (!this.channelContext.isRemoved()) break block43;
                log.info("{}, {}\u5df2\u7ecf\u5220\u9664\uff0c\u5907\u6ce8:{}\uff0c\u5f02\u5e38:{}", new Object[]{this.channelContext.getGroupContext(), this.channelContext, this.remark, this.throwable == null ? "\u65e0" : this.throwable.toString()});
                writeLock.unlock();
                return;
            }
            try {
                this.channelContext.getHandlerRunnable().setCanceled(true);
                this.channelContext.getSendRunnable().setCanceled(true);
                this.channelContext.getDecodeRunnable().clearMsgQueue();
                this.channelContext.getHandlerRunnable().clearMsgQueue();
                this.channelContext.getSendRunnable().clearMsgQueue();
                log.info("{}, {} \u51c6\u5907\u5173\u95ed\u8fde\u63a5, isNeedRemove:{}, {}", new Object[]{this.channelContext.getGroupContext(), this.channelContext, isRemove, this.remark});
                try {
                    if (isRemove) {
                        MaintainUtils.remove(this.channelContext);
                    } else {
                        groupContext.closeds.add(this.channelContext);
                        groupContext.connecteds.remove(this.channelContext);
                        MaintainUtils.close(this.channelContext);
                    }
                    try {
                        this.channelContext.setRemoved(isRemove);
                        this.channelContext.getGroupContext().getGroupStat().getClosed().incrementAndGet();
                        this.channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                    try {
                        aioListener.onAfterClose(this.channelContext, this.throwable, this.remark, isRemove);
                        this.channelContext.setClosed(true);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
                finally {
                    if (!isRemove && this.channelContext.isClosed() && isClientChannelContext) {
                        ClientChannelContext clientChannelContext = (ClientChannelContext)this.channelContext;
                        ReconnConf.put(clientChannelContext);
                    }
                }
                writeLock.unlock();
            }
            catch (Throwable e) {
                try {
                    log.error(this.throwable.toString(), e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        finally {
            this.channelContext.setWaitingClose(false);
        }
    }
}

